/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class CompassRenderer {
    private final IXaeroMinimap modMain;
    private final Minecraft mc;
    private double[] partialDest;

    public CompassRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.partialDest = new double[2];
    }

    public void drawCompass(PoseStack matrixStack, MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer nameBgBuilder) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{I18n.m_118938_((String)"gui.xaero_compass_north", (Object[])new Object[0]), I18n.m_118938_((String)"gui.xaero_compass_east", (Object[])new Object[0]), I18n.m_118938_((String)"gui.xaero_compass_south", (Object[])new Object[0]), I18n.m_118938_((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int defaultColor = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        GlStateManager.m_84110_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < 4; ++i) {
            int effectiveColor;
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            matrixStack.m_252880_(0.0f, 0.0f, 2.0f);
            matrixStack.m_85836_();
            MinimapElementOverMapRendererHandler.translatePosition(matrixStack, specW, specH, specW, specH, ps, pc, offx, offy, zoom, circle, this.partialDest);
            matrixStack.m_252880_(-1.0f, -1.0f, 0.0f);
            matrixStack.m_85841_(minimapScale, minimapScale, 1.0f);
            int halfW = this.mc.f_91062_.m_92895_(nesw[i]) / 2 - 1;
            int n = effectiveColor = i == 0 ? ModSettings.COLORS[this.modMain.getSettings().getNorthCompassColor()] : defaultColor;
            if (background) {
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), nameBgBuilder, -4 - addedFrame, -4 - addedFrame, 9 + 2 * addedFrame, 9 + 2 * addedFrame, 0x90000000 | effectiveColor & 0xFFFFFF);
                RenderSystem.m_69453_();
            }
            Misc.drawNormalText(matrixStack, nesw[i], (float)(-halfW + 1), -2.0f, effectiveColor, false, textRenderTypeBuffer);
            matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
            Misc.drawNormalText(matrixStack, nesw[i], (float)(-halfW), -3.0f, -1, false, textRenderTypeBuffer);
            matrixStack.m_85849_();
        }
        matrixStack.m_252880_(0.0f, 0.0f, 2.0f);
    }
}

