/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    public static final XaeroIcon FAILED = new XaeroIcon(null, 0, 0);
    public static final XaeroIcon DOT = new XaeroIcon(null, 0, 0);
    private EntityIconPrerenderer prerenderer;
    private final IXaeroMinimap modMain;
    private Map<ResourceLocation, EntityIconDefinition> iconDefinitions;
    private Map<String, XaeroIcon> cachedTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(IXaeroMinimap modMain, EntityIconPrerenderer prerenderer) {
        this.modMain = modMain;
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<ResourceLocation, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, XaeroIcon>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    public <T extends Entity> XaeroIcon getEntityHeadTexture(GuiGraphics guiGraphics, T entity, RenderTarget defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug, boolean debugEntityVariantIds) {
        String cacheKey;
        XaeroIcon cachedValue;
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = renderManager.m_114382_(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Exception e) {
                    MinimapLogs.LOGGER.error("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId, (Throwable)e);
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Exception e) {
                        MinimapLogs.LOGGER.error("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId, (Throwable)e);
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(entity.m_20078_());
        if (entity instanceof LivingEntity && !(entity instanceof Player)) {
            LivingEntity livingEntity;
            EquipmentSlot relevantArmourSlot = (livingEntity = (LivingEntity)entity) instanceof Horse ? EquipmentSlot.CHEST : EquipmentSlot.HEAD;
            ItemStack armorItemStack = livingEntity.m_6844_(relevantArmourSlot);
            if (armorItemStack != null && armorItemStack != ItemStack.f_41583_) {
                entityStringBuilder.append("%").append(ForgeRegistries.ITEMS.getKey((Object)armorItemStack.m_41720_()));
            }
            if (armorItemStack.m_204117_(ItemTags.f_265942_) && armorItemStack.m_41783_() != null && armorItemStack.m_41783_().m_128441_("Trim")) {
                CompoundTag trimTag = armorItemStack.m_41737_("Trim");
                if (trimTag.m_128425_("material", 8) && trimTag.m_128425_("pattern", 8)) {
                    entityStringBuilder.append("%").append(trimTag.m_128461_("material")).append("%").append(trimTag.m_128461_("pattern"));
                } else {
                    entityStringBuilder.append("%").append("inline_material").append("%").append("inline_pattern");
                }
            }
        }
        if ((cachedValue = this.cachedTextures.get(cacheKey = entityStringBuilder.toString())) == null) {
            ResourceLocation iconType;
            if (debugEntityVariantIds) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)entityVariantString));
            }
            String variantMapKey = entityVariantString;
            if (iconDefinition != null) {
                iconType = iconDefinition.getVariantType(variantMapKey);
                if (iconType == null) {
                    variantMapKey = "default";
                    iconType = iconDefinition.getVariantType(variantMapKey);
                }
            } else {
                iconType = EntityIconDefinition.MODEL_TYPE;
            }
            if (iconType == EntityIconDefinition.MODEL_TYPE) {
                if (this.canPrerender) {
                    EntityIconModelConfig variantModelConfig;
                    EntityIconModelConfig modelConfig = this.defaultModelConfig;
                    EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                    if (variantModelConfig != null) {
                        modelConfig = variantModelConfig;
                    }
                    cachedValue = this.prerenderer.prerender(guiGraphics, cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, this.defaultModelConfig, null, true, false, debug);
                    this.cachedTextures.put(cacheKey, cachedValue);
                    this.canPrerender = false;
                } else {
                    cachedValue = null;
                }
            } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                cachedValue = DOT;
                this.cachedTextures.put(cacheKey, cachedValue);
            } else if (this.canPrerender) {
                ResourceLocation sprite = iconDefinition.getSprite(variantMapKey);
                boolean isOutlined = iconType == EntityIconDefinition.OUTLINED_SPRITE;
                boolean isFlipped = !isOutlined && iconType != EntityIconDefinition.NORMAL_SPRITE;
                cachedValue = this.prerenderer.prerender(guiGraphics, cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, null, this.defaultModelConfig, sprite, isOutlined, isFlipped, debug);
                this.cachedTextures.put(cacheKey, cachedValue);
                this.canPrerender = false;
            } else {
                cachedValue = null;
            }
        }
        return cachedValue;
    }

    public void reset() {
        this.prerenderer.clearAtlases();
        this.cachedTextures.clear();
        MinimapLogs.LOGGER.info("Entity icon manager reset!");
    }

    public void resetResources() {
        MinimapLogs.LOGGER.info("Reloading entity icon resources...");
        Set entityIds = ForgeRegistries.ENTITY_TYPES.getKeys();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        MinimapLogs.LOGGER.info("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        this.iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            try {
                Resource resource;
                Optional oResource = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.m_135827_() + "/" + id.m_135815_() + ".json"));
                if (!oResource.isPresent() || (resource = (Resource)oResource.get()) == null) continue;
                resourceInput = resource.m_215507_();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> {
                    stringBuilder.append((String)line);
                    stringBuilder.append('\n');
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                MinimapLogs.LOGGER.error("Json syntax exception when loading the entity icon definition for " + id + ".", (Throwable)jse);
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelRenderDetection(EntityModel<?> model, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelRenderDetection(model, vertexConsumer, red, green, blue, alpha);
    }

    public void onModelPartRenderDetection(ModelPart modelRenderer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }
}

