/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods.pac.gui.element;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.mods.pac.SupportOpenPartiesAndClaims;
import xaero.common.mods.pac.gui.PartyPlayerIconRenderer;
import xaero.common.mods.pac.gui.element.PlayerDynamicInfoMinimapElement;
import xaero.common.mods.pac.gui.element.PlayerDynamicInfoReader;
import xaero.common.mods.pac.gui.element.PlayerDynamicInfoRenderContext;
import xaero.common.mods.pac.gui.element.PlayerDynamicInfoRenderProvider;
import xaero.pac.common.parties.party.api.IPartyMemberDynamicInfoSyncableAPI;

public final class PlayerDynamicInfoRenderer
extends MinimapElementRenderer<PlayerDynamicInfoMinimapElement, PlayerDynamicInfoRenderContext> {
    private final SupportOpenPartiesAndClaims pac;
    private final PartyPlayerIconRenderer partyPlayerIconRenderer;

    private PlayerDynamicInfoRenderer(SupportOpenPartiesAndClaims pac, PlayerDynamicInfoRenderContext context, PlayerDynamicInfoRenderProvider<PlayerDynamicInfoRenderContext> provider, PlayerDynamicInfoReader reader, PartyPlayerIconRenderer partyPlayerIconRenderer) {
        super(reader, provider, context);
        this.pac = pac;
        this.partyPlayerIconRenderer = partyPlayerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(Player player, PlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayer ? ((AbstractClientPlayer)player).m_108560_() : info.m_105337_();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.m_118627_((UUID)player.m_20148_());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        ((PlayerDynamicInfoRenderContext)this.context).outlineConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((PlayerDynamicInfoRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_NEAREST);
    }

    @Override
    public void postRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        rendererProvider.draw(((PlayerDynamicInfoRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.m_109911_();
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, Font font, RenderTarget framebuffer, MinimapRendererHelper helper, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, PlayerDynamicInfoMinimapElement e, double partialX, double partialY, boolean cave, float partialTicks) {
        if (!outOfBounds && e.wasRenderedOnRadar()) {
            return false;
        }
        PoseStack matrixStack = guiGraphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        IPartyMemberDynamicInfoSyncableAPI syncable = e.getSyncable();
        PlayerInfo info = mc.m_91403_().m_104949_(syncable.getPlayerId());
        if (info != null) {
            Player clientPlayer = mc.f_91073_.m_46003_(syncable.getPlayerId());
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, optionalDepth);
            matrixStack.m_85841_(optionalScale, optionalScale, 1.0f);
            helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), ((PlayerDynamicInfoRenderContext)this.context).outlineConsumer, -5.0f, -5.0f, 10, 10, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85837_(0.0, 0.0, 0.01);
            this.partyPlayerIconRenderer.renderIcon(mc, ((PlayerDynamicInfoRenderContext)this.context).uniqueTextureUIObjectRenderer, helper, matrixStack, clientPlayer, this.getPlayerSkin(clientPlayer, info));
            matrixStack.m_85849_();
        }
        return false;
    }

    @Override
    public boolean shouldRender(int location) {
        return this.pac.getModMain().getSettings().displayPacPlayers;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static final class Builder {
        private SupportOpenPartiesAndClaims pac;

        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public Builder setPac(SupportOpenPartiesAndClaims pac) {
            this.pac = pac;
            return this;
        }

        public PlayerDynamicInfoRenderer build() {
            if (this.pac == null) {
                throw new IllegalStateException();
            }
            return new PlayerDynamicInfoRenderer(this.pac, new PlayerDynamicInfoRenderContext(), new PlayerDynamicInfoRenderProvider<PlayerDynamicInfoRenderContext>(this.pac), new PlayerDynamicInfoReader(), new PartyPlayerIconRenderer());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

