/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModSettings;

public class ForgeEventHandler {
    private IXaeroMinimap modMain;
    private Screen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    public RealmsServer latestRealm;

    public ForgeEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenEvent.Opening event) {
        if (event.getNewScreen() instanceof OptionsScreen) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setNewScreen((Screen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (event.getNewScreen() instanceof TitleScreen || event.getNewScreen() instanceof JoinMultiplayerScreen) {
            this.modMain.getSettings().resetServerSettings();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (event.getNewScreen() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                GetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, "f_88773_");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(GetServerDetailsTask.class, "f_90327_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getNewScreen())) instanceof GetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (GetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.f_87473_ != this.latestRealm.f_87473_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        } else if ((event.getNewScreen() instanceof GuiAddWaypoint || event.getNewScreen() instanceof GuiWaypoints) && (mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS) || mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_HARMFUL))) {
            event.setCanceled(true);
        }
        this.lastGuiOpen = event.getNewScreen();
    }

    protected void handleRenderGameOverlayEventPreLayerOverridable(RenderGuiOverlayEvent.Pre event) {
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGuiEvent.Pre event) {
        XaeroMinimapCore.beforeIngameGuiRender(event.getPartialTick());
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPostLayer(RenderGuiOverlayEvent.Post event) {
        IPotionEffectsPushBox potionEffectsPushBox;
        if (event.getOverlay() == VanillaGuiOverlay.POTION_ICONS.type() && (potionEffectsPushBox = this.modMain.getInterfaces().getPotionEffectPushBox()) != null) {
            potionEffectsPushBox.setActive(true);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPreLayer(RenderGuiOverlayEvent.Pre event) {
        XaeroMinimapSession minimapSession;
        this.handleRenderGameOverlayEventPreLayerOverridable(event);
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null && minimapSession.getMinimapProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (this.handleClientSendChat(e.getMessage())) {
            e.setCanceled(true);
        }
    }

    public boolean handleClientSendChat(String message) {
        if (message.startsWith("xaero_waypoint_add:")) {
            String[] args = message.split(":");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
            return true;
        }
        if (message.equals("xaero_tp_anyway")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        GameProfile gameProfile;
        if (e.getMessage() == null) {
            return;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(e.getSender());
        GameProfile gameProfile2 = gameProfile = playerInfo == null ? null : playerInfo.m_105312_();
        if (gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile)) {
            e.setCanceled(true);
        }
    }

    public boolean handleClientPlayerChatReceivedEvent(ChatType.Bound chatType, Component component, GameProfile gameProfile) {
        if (component == null) {
            return false;
        }
        return this.handleChatMessage(gameProfile == null ? I18n.m_118938_((String)"gui.xaero_waypoint_somebody_shared", (Object[])new Object[0]) : gameProfile.getName(), component);
    }

    public boolean handleClientSystemChatReceivedEvent(Component component) {
        XaeroMinimapSession minimapSession;
        if (component == null) {
            return false;
        }
        String textString = component.getString();
        if (textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(false);
            minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(false);
        }
        if (textString.contains("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(true);
        }
        if (textString.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(true);
        }
        return this.handleChatMessage(I18n.m_118938_((String)"gui.xaero_waypoint_server_shared", (Object[])new Object[0]), component);
    }

    private boolean handleChatMessage(String playerName, Component text) {
        String textString = text.getString();
        if (textString.contains("xaero_waypoint:") || textString.contains("xaero-waypoint:")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(playerName, textString);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void handleRenderSolidBlocks(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            XaeroMinimapCore.onProjectionMatrix(event.getProjectionMatrix());
            XaeroMinimapCore.onWorldModelViewMatrix(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.Render.Post event) {
        if (Patreon.needsNotification() && event.getScreen() instanceof TitleScreen) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    public void handlePlayerSetSpawn(Level world, BlockPos spawn) {
        XaeroMinimapSession minimapSession;
        if (world instanceof ClientLevel && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(spawn, (ClientLevel)world);
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        XaeroMinimapSession minimapSession;
        if (event.getLevel() instanceof ClientLevel && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.getEntityRadar().updateRadar(null, null, null, minimap);
        }
    }
}

