/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.controls.event.KeyEvent;

public class KeyEventHandler {
    public ArrayList<KeyEvent> keyEvents = new ArrayList();
    public ArrayList<KeyEvent> oldKeyEvents = new ArrayList();

    private boolean eventExists(KeyMapping kb) {
        for (KeyEvent o : this.keyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return this.oldEventExists(kb);
    }

    private boolean oldEventExists(KeyMapping kb) {
        for (KeyEvent o : this.oldKeyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return false;
    }

    public void handleEvents(Minecraft mc, XaeroMinimapSession minimapSession) {
        KeyEvent ke;
        int i;
        for (i = 0; i < this.oldKeyEvents.size(); ++i) {
            ke = this.oldKeyEvents.get(i);
            if (minimapSession.getControls().isDown(ke.getKb())) continue;
            minimapSession.getControls().keyUp(ke.getKb(), ke.isTickEnd());
            while (ke.getKb().consumeClick()) {
            }
            this.oldKeyEvents.remove(i);
            --i;
        }
        for (i = 0; i < this.keyEvents.size(); ++i) {
            ke = this.keyEvents.get(i);
            if (mc.screen == null && (!ke.wasFiredOnce() || minimapSession.getControls().isDown(ke.getKb()))) {
                minimapSession.getControls().keyDown(ke.getKb(), ke.isTickEnd(), ke.isRepeat());
            }
            if (!ke.isRepeat() || !minimapSession.getControls().isDown(ke.getKb())) {
                if (!this.oldEventExists(ke.getKb())) {
                    this.oldKeyEvents.add(ke);
                }
                this.keyEvents.remove(i);
                --i;
            }
            ke.setFiredOnce();
        }
    }

    public void onKeyInput(Minecraft mc, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        if (mc.screen != null) {
            return;
        }
        List<KeyMapping> kbs = modMain.getControlsRegister().keybindings;
        List<KeyMapping> vkbs = modMain.getControlsRegister().vanillaKeyBindings;
        for (KeyMapping kb : kbs) {
            try {
                boolean pressed = false;
                if (vkbs.contains(kb)) {
                    pressed = kb.isDown();
                } else {
                    pressed = kb.consumeClick();
                    while (kb.consumeClick()) {
                    }
                }
                if (!pressed || this.eventExists(kb)) continue;
                this.keyEvents.add(new KeyEvent(kb, false, modMain.getSettings().isKeyRepeat(kb), true));
            }
            catch (Exception exception) {}
        }
    }
}

