/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.RenderType;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private ByteBufferBuilder sharedBuffer = new ByteBufferBuilder(256);
    private BufferBuilder currentBufferBuilder;
    private List<MeshData> buffersForDrawCalls = new ArrayList<MeshData>();
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinderShader;
    private IntConsumer textureBinder;
    private Runnable textureFinalizer;
    private int prevTextureId;
    private VertexFormat prevFormat;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinderShader, IntConsumer textureBinder, Runnable textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinderShader = textureBinderShader;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            IntConsumer textureBinder = this.textureBinder;
            IntConsumer textureBinderShader = this.textureBinderShader;
            Runnable textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.renderType.setupRenderState();
            this.endBuffer(this.currentBufferBuilder);
            boolean first = true;
            int shaderProgram = RenderSystem.getShader().getId();
            for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                int texture = this.texturesForDrawCalls.getInt(i);
                MeshData buffer = this.buffersForDrawCalls.get(i);
                if (texture == -1) {
                    texture = 0;
                }
                if (first) {
                    textureBinderShader.accept(texture);
                    BufferUploader.drawWithShader((MeshData)buffer);
                    ProgramManager.glUseProgram((int)shaderProgram);
                } else {
                    textureBinder.accept(texture);
                    BufferUploader.draw((MeshData)buffer);
                }
                if (hasTextureFinalizer) {
                    if (first) {
                        textureBinder.accept(texture);
                    }
                    textureFinalizer.run();
                }
                first = false;
            }
            textureBinder.accept(0);
            this.renderType.clearRenderState();
        }
        ProgramManager.glUseProgram((int)0);
        this.texturesForDrawCalls.clear();
        this.buffersForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    private void endBuffer(BufferBuilder builder) {
        this.buffersForDrawCalls.add(builder.build());
    }

    public BufferBuilder begin(VertexFormat.Mode mode, VertexFormat format, int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId || !Objects.equals(this.prevFormat, format)) {
            if (this.prevTextureId != -1) {
                this.endBuffer(this.currentBufferBuilder);
            }
            this.currentBufferBuilder = new BufferBuilder(this.sharedBuffer, mode, format);
            this.prevTextureId = textureId;
            this.prevFormat = format;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.currentBufferBuilder;
    }
}

