/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiSettings;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModOptions;
import xaero.hud.minimap.MinimapLogs;

public class GuiSlimeSeed
extends GuiSettings {
    public EditBox seedTextField;
    private final String fullWorldID;

    public GuiSlimeSeed(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen parent, Screen escape) {
        super(modMain, (Component)Component.translatable((String)"gui.xaero_slime_chunks"), parent, escape);
        this.entries = GuiSlimeSeed.entriesFromOptions(new ModOptions[]{ModOptions.SLIME_CHUNKS, ModOptions.OPEN_SLIME_SETTINGS});
        this.fullWorldID = waypointsManager.getCurrentContainerAndWorldID();
    }

    @Override
    public void init() {
        super.init();
        this.seedTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 68, 200, 20, (Component)Component.translatable((String)"gui.xaero_used_seed"));
        this.seedTextField.setValue(String.valueOf(this.modMain.getSettings().getSlimeChunksSeed(this.fullWorldID) == null ? "" : this.modMain.getSettings().getSlimeChunksSeed(this.fullWorldID)));
        this.addRenderableWidget((GuiEventListener)this.seedTextField);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.seedTextField.render(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"gui.xaero_used_seed", (Object[])new Object[0]), this.width / 2, this.height / 7 + 55, 0xFFFFFF);
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257) {
            this.goBack();
        }
        this.updateSlimeSeed();
        return result;
    }

    @Override
    public boolean charTyped(char par1, int par2) {
        boolean result = super.charTyped(par1, par2);
        this.updateSlimeSeed();
        return result;
    }

    private void updateSlimeSeed() {
        String s = this.seedTextField.getValue();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            try {
                long j = Long.parseLong(s);
                this.modMain.getSettings().setSlimeChunksSeed(j, this.fullWorldID);
            }
            catch (NumberFormatException numberformatexception) {
                this.modMain.getSettings().setSlimeChunksSeed(s.hashCode(), this.fullWorldID);
            }
        }
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }
}

