/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;

public class RadarUtils {
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    public static boolean hostileException(Entity e) {
        if (e instanceof Piglin) {
            return ((Piglin)e).isBaby();
        }
        return false;
    }

    public static boolean isTamed(Entity e, Player p) {
        if (e instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)e;
            if (tameable.isTame() && p.getUUID().equals(tameable.getOwnerUUID())) {
                return true;
            }
        } else if (e instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)e;
            if (horse.isTamed() && (horse.getOwnerUUID() == null || p.getUUID().equals(horse.getOwnerUUID()))) {
                return true;
            }
        } else if (e instanceof Fox) {
            Fox fox = (Fox)e;
            if (FOX_TRUSTED_UUID_SECONDARY != null && p.getUUID().equals(((Optional)fox.getEntityData().get(FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            if (FOX_TRUSTED_UUID_MAIN != null && p.getUUID().equals(((Optional)fox.getEntityData().get(FOX_TRUSTED_UUID_MAIN)).orElse(null))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHostile(Entity e) {
        return Minecraft.getInstance().level.getDifficulty() != Difficulty.PEACEFUL && !RadarUtils.hostileException(e) && (e instanceof Monster || e instanceof Enemy || e.getSoundSource() == SoundSource.HOSTILE);
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = Misc.getFieldReflection(Fox.class, "DATA_TRUSTED_ID_0", "field_17951", "Lnet/minecraft/class_2940;", "f_28439_");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        try {
            foxTrustMainField = Misc.getFieldReflection(Fox.class, "DATA_TRUSTED_ID_1", "field_17952", "Lnet/minecraft/class_2940;", "f_28440_");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (foxTrustSecondaryField != null) {
            try {
                boolean accessibleBU = foxTrustSecondaryField.isAccessible();
                foxTrustSecondaryField.setAccessible(true);
                FOX_TRUSTED_UUID_SECONDARY = (EntityDataAccessor)foxTrustSecondaryField.get(null);
                foxTrustSecondaryField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (foxTrustMainField != null) {
            try {
                boolean accessibleBU = foxTrustMainField.isAccessible();
                foxTrustMainField.setAccessible(true);
                FOX_TRUSTED_UUID_MAIN = (EntityDataAccessor)foxTrustMainField.get(null);
                foxTrustMainField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }
}

