/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;

public class ModelRenderDetectionElement {
    public EntityModel<?> model;
    public ResourceLocation renderTexture;
    public TextureAtlasSprite renderAtlasSprite;
    CustomRenderTypes.EntityIconLayerPhases layerPhases;
    public int color;
    public boolean allVisible;
    private HashMap<ModelPart, ModelPartRenderDetectionInfo> visibleParts;

    public ModelRenderDetectionElement(EntityModel<?> model, ResourceLocation renderTexture, TextureAtlasSprite renderAtlasSprite, CustomRenderTypes.EntityIconLayerPhases layerPhases, int color) {
        this.model = model;
        this.renderTexture = renderTexture;
        this.renderAtlasSprite = renderAtlasSprite;
        this.layerPhases = layerPhases;
        this.color = color;
    }

    public String toString() {
        return String.valueOf(this.model) + " " + String.valueOf(this.layerPhases.texture);
    }

    public void addVisibleModelPart(ModelPart part, int color) {
        if (this.visibleParts == null) {
            this.visibleParts = new HashMap();
        }
        this.visibleParts.put(part, new ModelPartRenderDetectionInfo(part, color));
    }

    public ModelPartRenderDetectionInfo getModelPartRenderInfo(ModelPart part) {
        ModelPartRenderDetectionInfo mprdi;
        ModelPartRenderDetectionInfo modelPartRenderDetectionInfo = mprdi = this.visibleParts == null ? null : this.visibleParts.get(part);
        if (mprdi == null && this.allVisible) {
            mprdi = new ModelPartRenderDetectionInfo(part, this.color);
        }
        return mprdi;
    }

    public boolean isEmpty() {
        return !this.allVisible && (this.visibleParts == null || this.visibleParts.isEmpty());
    }

    public boolean sameVisibility(ModelRenderDetectionElement other) {
        HashMap<ModelPart, ModelPartRenderDetectionInfo> otherVisibleParts;
        if (this.visibleParts == null != ((otherVisibleParts = other.visibleParts) == null)) {
            return false;
        }
        if (this.visibleParts == null) {
            return true;
        }
        if (this.visibleParts.size() != otherVisibleParts.size()) {
            return false;
        }
        Set<ModelPart> keySet = this.visibleParts.keySet();
        for (ModelPart key : keySet) {
            if (otherVisibleParts.containsKey(key)) continue;
            return false;
        }
        return true;
    }
}

