/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.armor;

import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import xaero.common.minimap.render.radar.armor.EntityIconArmor;

public class EntityIconArmorHandler {
    public EntityIconArmor getArmor(LivingEntity livingEntity) {
        EntityIconArmor armor = null;
        EquipmentSlot relevantArmourSlot = livingEntity instanceof Horse ? EquipmentSlot.CHEST : EquipmentSlot.HEAD;
        ItemStack armorItemStack = livingEntity.getItemBySlot(relevantArmourSlot);
        if (armorItemStack != null && armorItemStack != ItemStack.EMPTY) {
            Item armorItem = armorItemStack.getItem();
            TrimMaterial trimMaterial = null;
            TrimPattern trimPattern = null;
            if (armorItemStack.is(ItemTags.TRIMMABLE_ARMOR) && armorItemStack.has(DataComponents.TRIM)) {
                ArmorTrim trim = (ArmorTrim)armorItemStack.get(DataComponents.TRIM);
                trimMaterial = (TrimMaterial)trim.material().value();
                trimPattern = (TrimPattern)trim.pattern().value();
            }
            armor = new EntityIconArmor(armorItem, trimMaterial, trimPattern);
        }
        return armor;
    }
}

