/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.GuiHelper;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.minimap.waypoints.render.WaypointGuiRenderContext;
import xaero.common.minimap.waypoints.render.WaypointReader;
import xaero.common.minimap.waypoints.render.WaypointRenderProvider;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.render.TextureLocations;

public final class WaypointsGuiRenderer
extends MinimapElementRenderer<Waypoint, WaypointGuiRenderContext> {
    private final IXaeroMinimap modMain;
    private final WaypointDeleter waypointReachDeleter;

    private WaypointsGuiRenderer(IXaeroMinimap modMain, WaypointReader elementReader, WaypointRenderProvider provider, WaypointGuiRenderContext context, WaypointDeleter waypointReachDeleter) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.waypointReachDeleter = waypointReachDeleter;
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, Font font, RenderTarget framebuffer, MinimapRendererHelper helper, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, Waypoint w, double partialX, double partialY, boolean cave, float partialTicks) {
        PoseStack matrixStack = guiGraphics.pose();
        if ((((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints || w.getWaypointType() != 1 && w.getWaypointType() != 2) && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L) {
            double correctOffZ;
            double correctDistance;
            double correctOffX = renderEntity.getX() - (double)w.getX(((WaypointGuiRenderContext)this.context).dimDiv);
            double correctOffY = renderEntity.getY() - (double)w.getY();
            if (!w.isYIncluded()) {
                correctOffY = 0.0;
            }
            if ((correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + (correctOffZ = renderEntity.getZ() - (double)w.getZ(((WaypointGuiRenderContext)this.context).dimDiv)) * correctOffZ)) < 4.0) {
                this.waypointReachDeleter.add(w);
            }
        }
        matrixStack.translate(-1.0, -1.0, optionalDepth);
        if (((WaypointGuiRenderContext)this.context).scale <= 0 || location != 1) {
            matrixStack.scale(optionalScale, optionalScale, 1.0f);
        } else {
            matrixStack.scale((float)((WaypointGuiRenderContext)this.context).scale, (float)((WaypointGuiRenderContext)this.context).scale, 1.0f);
        }
        this.drawIconOnGUI(guiGraphics, helper, w, ((WaypointGuiRenderContext)this.context).settings, 0, 0, renderTypeBuffers, ((WaypointGuiRenderContext)this.context).waypointBackgroundConsumer);
        return true;
    }

    @Override
    public void preRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        ((WaypointGuiRenderContext)this.context).settings = modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).waypointBackgroundConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints = modMain.getSettings().deleteReachedDeathpoints;
        ((WaypointGuiRenderContext)this.context).scale = modMain.getSettings().waypointOnMapScale;
        this.updateWaypointCollection(renderX, renderY, renderZ, modMain);
    }

    @Override
    public void postRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        renderTypeBuffers.endBatch();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), modMain.getSettings().renderAllSets);
    }

    public void updateWaypointCollection(double renderX, double renderY, double renderZ, IXaeroMinimap modMain) {
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        List<Waypoint> sortingList = ((WaypointGuiRenderContext)this.context).sortingList;
        sortingList.clear();
        if (waypointsManager.getWaypoints() != null) {
            if (modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    sortingList.addAll(setEntry.getValue().getList());
                }
            } else {
                sortingList.addAll(waypointsManager.getWaypoints().getList());
            }
        }
        if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        this.waypointReachDeleter.begin();
        ((WaypointGuiRenderContext)this.context).dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentWorld());
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Waypoint.RENDER_SORTING_POS = new Vec3(cameraPos.x * ((WaypointGuiRenderContext)this.context).dimDiv, cameraPos.y, cameraPos.z * ((WaypointGuiRenderContext)this.context).dimDiv);
        ModSettings settings = modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).filterParams.setParams(cameraPos.x, cameraPos.y, cameraPos.z, null, ((WaypointGuiRenderContext)this.context).dimDiv, settings.getDeathpoints(), settings.temporaryWaypointsGlobal, settings.getMaxWaypointsDistance(), settings.waypointsDistanceMin, 0.0, settings.dimensionScaledMaxWaypointDistance);
    }

    public void drawIconOnGUI(GuiGraphics guiGraphics, MinimapRendererHelper rendererHelper, Waypoint w, ModSettings settings, int drawX, int drawY, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer) {
        PoseStack matrixStack = guiGraphics.pose();
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        int initialsWidth = w.getWaypointType() == 1 ? 7 : Minecraft.getInstance().font.width(w.getSymbol());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5;
        rendererHelper.addColoredRectToExistingBuffer(matrixStack.last().pose(), waypointBackgroundConsumer, rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        if (w.getWaypointType() != 1) {
            Misc.drawNormalText(matrixStack, w.getSymbol(), (float)(drawX + 1 - initialsWidth / 2), (float)(drawY - 3), -1, true, renderTypeBuffer);
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureLocations.GUI_TEXTURES);
            RenderSystem.setShaderColor((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            GuiHelper.blit(matrixStack, rectX1 + 1, rectY1 + 1, 0.0f, 78.0f, 9, 9);
            RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            GuiHelper.blit(matrixStack, rectX1, rectY1, 0.0f, 78.0f, 9, 9);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, GuiGraphics guiGraphics, Window res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                MultiBufferSource.BufferSource textRenderTypeBuffers = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                Misc.drawCenteredPiercingText(guiGraphics.pose(), I18n.get((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), (float)(res.getGuiScaledWidth() / 2), (float)(res.getGuiScaledHeight() / 2 + 50), c, true, textRenderTypeBuffers);
                textRenderTypeBuffers.endBatch();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }

    @Override
    public boolean shouldRender(int location) {
        return (location != 1 && location != 0 || this.modMain.getSettings().getShowWaypoints()) && !Misc.hasEffect(Effects.NO_WAYPOINTS) && !Misc.hasEffect(Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    public static final class Builder {
        private WaypointDeleter waypointDeleter;
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            this.setWaypointDeleter(null);
            return this;
        }

        public Builder setWaypointDeleter(WaypointDeleter waypointDeleter) {
            this.waypointDeleter = waypointDeleter;
            return this;
        }

        public WaypointsGuiRenderer build() {
            if (this.waypointDeleter == null) {
                throw new IllegalStateException();
            }
            WaypointGuiRenderContext context = new WaypointGuiRenderContext();
            context.filter = w -> {
                WaypointFilterParams filterParams = context.filterParams;
                boolean deathpoints = filterParams.deathpoints;
                if (w.isDisabled() || w.getVisibilityType() == 2 || w.getVisibilityType() == 3 || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                    return false;
                }
                double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraX;
                double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraZ;
                double distanceScale = context.filterParams.dimensionScaleDistance ? Minecraft.getInstance().level.dimensionType().coordinateScale() : 1.0;
                double distance = Math.sqrt(offx * offx + offz * offz) * distanceScale;
                double waypointsDistance = filterParams.waypointsDistance;
                return w.isOneoffDestination() || w.getWaypointType() == 1 || w.isGlobal() || w.isTemporary() && filterParams.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance > waypointsDistance);
            };
            return new WaypointsGuiRenderer(this.modMain, new WaypointReader(), new WaypointRenderProvider(), context, this.waypointDeleter);
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

