/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.ChainBlock;
import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.IForgeRegistry;

public enum LanternMaterial {
    NORMAL(true, false, "", null, null, null, null, 0),
    OBSIDIAN(true, true, "Obsidian", () -> Items.f_41999_, null, () -> Items.f_41999_, () -> Items.f_41999_, 8),
    BASALT(true, true, "Basalt", () -> Items.f_42051_, null, () -> Items.f_42051_, () -> Items.f_42051_, 8),
    ANDESITE(true, true, "Andesite", () -> Items.f_42170_, null, () -> Items.f_42170_, () -> Items.f_42170_, 8),
    DIORITE(true, true, "Diorite", () -> Items.f_42064_, null, () -> Items.f_42064_, () -> Items.f_42064_, 8),
    GRANITE(true, true, "Granite", () -> Items.f_41958_, null, () -> Items.f_41958_, () -> Items.f_41958_, 8),
    NORMAL_SANDSTONE(true, true, "Sandstone", () -> Items.f_41856_, null, () -> Items.f_41856_, () -> Items.f_41856_, 8),
    RED_SANDSTONE(true, true, "Red Sandstone", () -> Items.f_42252_, null, () -> Items.f_42252_, () -> Items.f_42252_, 8),
    SMOOTH_STONE(true, true, "Smooth Stone", () -> Items.f_41994_, null, () -> Items.f_41994_, () -> Items.f_41994_, 8),
    END_STONE(true, true, "End Stone", () -> Items.f_42102_, null, () -> Items.f_42102_, () -> Items.f_42102_, 8),
    QUARTZ(true, true, "Quartz", () -> Items.f_42692_, () -> Items.f_42692_, () -> Items.f_42157_, () -> Items.f_42692_, 4),
    PRISMARINE(true, true, "Prismarine", () -> Items.f_42695_, () -> Items.f_42695_, () -> Items.f_42193_, () -> Items.f_42695_, 6),
    DARK_PRISMARINE(true, true, "Dark Prismarine", () -> Items.f_42194_, null, () -> Items.f_42194_, () -> Items.f_42695_, 6),
    BLACKSTONE(true, true, "Blackstone", () -> Items.f_42755_, null, () -> Items.f_42755_, () -> Items.f_42755_, 4),
    NORMAL_NETHER_BRICKS(true, true, "Nether Brick", () -> Items.f_42691_, null, () -> Items.f_42095_, () -> Items.f_42691_, 4),
    RED_NETHER_BRICKS(true, true, "Red Nether Brick", () -> Items.f_42261_, null, () -> Items.f_42261_, () -> Items.f_42691_, 4),
    CRIMSON(true, true, "Crimson", () -> Items.f_42797_, null, () -> Items.f_42797_, () -> Items.f_42797_, 6),
    WARPED(true, true, "Warped", () -> Items.f_42798_, null, () -> Items.f_42798_, () -> Items.f_42798_, 6),
    PURPUR(true, true, "Purpur", () -> Items.f_42731_, () -> Items.f_42731_, () -> Items.f_42004_, () -> Items.f_42731_, 4),
    BRICKS(true, true, "Brick", () -> Items.f_42460_, () -> Items.f_42460_, () -> Items.f_41995_, () -> Items.f_42460_, 4);

    public final boolean canBeColored;
    public final boolean hasChains;
    private LanternBlock lanternBlock;
    private final Map<LanternColor, LanternBlock> coloredLanternBlocks = new EnumMap<LanternColor, LanternBlock>(LanternColor.class);
    private ChainBlock chainBlock;
    private Item lanternItem;
    private final Map<LanternColor, Item> coloredLanternItems = new EnumMap<LanternColor, Item>(LanternColor.class);
    private Item chainItem;
    public final String englishTranslation;
    public final ItemLike primaryLanternIngredient;
    public final ItemLike secondaryLanternIngredient;
    public final ItemLike primaryChainIngredient;
    public final ItemLike secondaryChainIngredient;
    public final int chainRecipeCount;

    private LanternMaterial(boolean canBeColored, boolean hasChains, String englishTranslation, ItemLike primaryLanternIngredient, ItemLike secondaryLanternIngredient, ItemLike primaryChainIngredient, ItemLike secondaryChainIngredient, int chainRecipeCount) {
        this.canBeColored = canBeColored;
        this.hasChains = hasChains;
        this.englishTranslation = englishTranslation;
        this.primaryLanternIngredient = primaryLanternIngredient;
        this.secondaryLanternIngredient = secondaryLanternIngredient;
        this.primaryChainIngredient = primaryChainIngredient;
        this.secondaryChainIngredient = secondaryChainIngredient;
        this.chainRecipeCount = chainRecipeCount;
    }

    public Block getLanternBlock() {
        return this.lanternBlock;
    }

    public Block getLanternBlock(LanternColor color) {
        if (color == null) {
            return this.getLanternBlock();
        }
        return (Block)this.coloredLanternBlocks.get((Object)color);
    }

    public ChainBlock getChainBlock() {
        return this.chainBlock;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public BlockBehaviour.Properties getLanternBlockProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60953_(state -> LanternBlock.emitsLight(state) ? 15 : 0);
    }

    public BlockBehaviour.Properties getChainBlockProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50184_);
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        if (this.lanternBlock != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        this.lanternBlock = new LanternBlock(this, null);
        registry.register(this.getSuffix() + "_lantern", (Object)this.lanternBlock);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = new LanternBlock(this, color);
                this.coloredLanternBlocks.put(color, block);
                registry.register(color.getSuffix() + "_" + this.getSuffix() + "_lantern", (Object)block);
            }
        }
        if (this.hasChains) {
            this.chainBlock = new ChainBlock(this);
            registry.register(this.getSuffix() + "_chain", (Object)this.chainBlock);
        }
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        if (this.lanternItem != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.lanternBlock == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        if (this == NORMAL) {
            this.lanternItem = new BlockItem((Block)this.lanternBlock, new Item.Properties().m_41491_(AdditionalLanterns.GROUP));
            registry.register(new ResourceLocation("minecraft", "lantern"), (Object)this.lanternItem);
        } else {
            this.lanternItem = new BlockItem((Block)this.lanternBlock, new Item.Properties().m_41491_(AdditionalLanterns.GROUP));
            registry.register(this.getSuffix() + "_lantern", (Object)this.lanternItem);
        }
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = this.coloredLanternBlocks.get((Object)color);
                BlockItem item = new BlockItem((Block)block, new Item.Properties().m_41491_(AdditionalLanterns.GROUP));
                this.coloredLanternItems.put(color, (Item)item);
                registry.register(color.getSuffix() + "_" + this.getSuffix() + "_lantern", (Object)item);
            }
        }
        if (this.hasChains) {
            this.chainItem = new BlockItem((Block)this.chainBlock, new Item.Properties().m_41491_(AdditionalLanterns.GROUP));
            registry.register(this.getSuffix() + "_chain", (Object)this.chainItem);
        }
    }
}

