/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.data.event.GatherDataEvent;

public class LanternBlockModelProvider
extends BlockModelProvider {
    public LanternBlockModelProvider(GatherDataEvent e) {
        super(e.getGenerator(), "additionallanterns", e.getExistingFileHelper());
    }

    protected void registerModels() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addModels(material);
        }
    }

    public void addModels(LanternMaterial material) {
        this.addModel(material, null);
        if (material.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                this.addModel(material, color);
            }
        }
        if (material == LanternMaterial.NORMAL || material.hasChains) {
            this.addChainModel(material);
        }
    }

    public void addModel(LanternMaterial material, LanternColor color) {
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(LanternBlockModelProvider.getModelLocation(material, color, false, false), LanternBlockModelProvider.getModelLocation(false))).texture("material", LanternBlockModelProvider.getMaterialTexture(material))).texture("color", LanternBlockModelProvider.getColorTexture(color, false));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(LanternBlockModelProvider.getModelLocation(material, color, false, true), LanternBlockModelProvider.getModelLocation(false))).texture("material", LanternBlockModelProvider.getMaterialTexture(material))).texture("color", LanternBlockModelProvider.getColorTexture(color, true));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(LanternBlockModelProvider.getModelLocation(material, color, true, false), LanternBlockModelProvider.getModelLocation(true))).texture("material", LanternBlockModelProvider.getMaterialTexture(material))).texture("color", LanternBlockModelProvider.getColorTexture(color, false));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(LanternBlockModelProvider.getModelLocation(material, color, true, true), LanternBlockModelProvider.getModelLocation(true))).texture("material", LanternBlockModelProvider.getMaterialTexture(material))).texture("color", LanternBlockModelProvider.getColorTexture(color, true));
    }

    public void addChainModel(LanternMaterial material) {
        ((BlockModelBuilder)this.withExistingParent(LanternBlockModelProvider.getChainModelLocation(material), LanternBlockModelProvider.getChainModelLocation())).texture("chain", LanternBlockModelProvider.getChainMaterialTexture(material));
    }

    public static String getModelLocation(LanternMaterial material, LanternColor color, boolean hanging, boolean on) {
        return color == null ? (hanging ? (on ? "block/" + material.getSuffix() + "_hanging_lantern" : "block/" + material.getSuffix() + "_hanging_lantern_off") : (on ? "block/" + material.getSuffix() + "_lantern" : "block/" + material.getSuffix() + "_lantern_off")) : (hanging ? (on ? "block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern" : "block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern_off") : (on ? "block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern" : "block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern_off"));
    }

    public static ResourceLocation getModelLocation(boolean hanging) {
        return hanging ? new ResourceLocation("additionallanterns", "block/hanging_lantern") : new ResourceLocation("additionallanterns", "block/lantern");
    }

    public static ResourceLocation getMaterialTexture(LanternMaterial material) {
        return new ResourceLocation("additionallanterns", "block/materials/" + material.getSuffix() + "_lantern");
    }

    public static ResourceLocation getColorTexture(LanternColor color, boolean on) {
        return color == null ? (on ? new ResourceLocation("minecraft", "block/lantern") : new ResourceLocation("additionallanterns", "block/lantern_off")) : (on ? new ResourceLocation("additionallanterns", "block/colors/" + color.getSuffix() + "_lantern") : new ResourceLocation("additionallanterns", "block/colors/" + color.getSuffix() + "_lantern_off"));
    }

    public static String getChainModelLocation(LanternMaterial material) {
        return "block/" + material.getSuffix() + "_chain";
    }

    public static ResourceLocation getChainModelLocation() {
        return new ResourceLocation("additionallanterns", "block/chain");
    }

    public static ResourceLocation getChainMaterialTexture(LanternMaterial material) {
        if (material == LanternMaterial.NORMAL) {
            return new ResourceLocation("minecraft", "block/chain");
        }
        return new ResourceLocation("additionallanterns", "block/materials/" + material.getSuffix() + "_chain");
    }
}

