/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.data.event.GatherDataEvent;

public class LanternRecipeProvider
extends RecipeProvider {
    public LanternRecipeProvider(GatherDataEvent e) {
        super(e.getGenerator());
    }

    protected void m_176531_(Consumer<FinishedRecipe> recipeConsumer) {
        for (LanternMaterial material : LanternMaterial.values()) {
            LanternRecipeProvider.addMaterialRecipes(material, recipeConsumer);
        }
    }

    private static void addMaterialRecipes(LanternMaterial material, Consumer<FinishedRecipe> recipeConsumer) {
        LanternRecipeProvider.addLanternRecipe(material, recipeConsumer);
        if (material.canBeColored) {
            LanternRecipeProvider.addColorRecipe(material, null, recipeConsumer);
            for (LanternColor color : LanternColor.values()) {
                LanternRecipeProvider.addColorRecipe(material, color, recipeConsumer);
            }
        }
        if (material.hasChains) {
            LanternRecipeProvider.addChainRecipe(material, recipeConsumer);
        }
    }

    private static void addLanternRecipe(LanternMaterial material, Consumer<FinishedRecipe> recipeConsumer) {
        if (material.primaryLanternIngredient == null && material.secondaryLanternIngredient == null) {
            return;
        }
        if (material.primaryLanternIngredient == null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)material.getLanternBlock()).m_126130_("B B").m_126130_(" C ").m_126130_("B B").m_126127_(Character.valueOf('B'), material.secondaryLanternIngredient).m_126127_(Character.valueOf('C'), () -> Items.f_42000_).m_126132_("has_torch", (CriterionTriggerInstance)LanternRecipeProvider.m_125977_(() -> Items.f_42000_)).m_176498_(recipeConsumer);
        } else if (material.secondaryLanternIngredient == null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)material.getLanternBlock()).m_126130_(" A ").m_126130_("ACA").m_126130_(" A ").m_126127_(Character.valueOf('A'), material.primaryLanternIngredient).m_126127_(Character.valueOf('C'), () -> Items.f_42000_).m_126132_("has_torch", (CriterionTriggerInstance)LanternRecipeProvider.m_125977_(() -> Items.f_42000_)).m_176498_(recipeConsumer);
        } else {
            ShapedRecipeBuilder.m_126116_((ItemLike)material.getLanternBlock()).m_126130_("BAB").m_126130_("ACA").m_126130_("BAB").m_126127_(Character.valueOf('A'), material.primaryLanternIngredient).m_126127_(Character.valueOf('B'), material.secondaryLanternIngredient).m_126127_(Character.valueOf('C'), () -> Items.f_42000_).m_126132_("has_torch", (CriterionTriggerInstance)LanternRecipeProvider.m_125977_(() -> Items.f_42000_)).m_176498_(recipeConsumer);
        }
    }

    private static void addColorRecipe(LanternMaterial material, LanternColor color, Consumer<FinishedRecipe> recipeConsumer) {
        if (color == null) {
            ShapelessRecipeBuilder.m_126189_((ItemLike)material.getLanternBlock()).m_206419_(LanternRecipeProvider.getMaterialLanternTag(material)).m_126132_("has_lantern", (CriterionTriggerInstance)LanternRecipeProvider.m_206406_(LanternRecipeProvider.getMaterialLanternTag(material))).m_126140_(recipeConsumer, new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_colorless"));
        } else {
            ShapelessRecipeBuilder.m_126189_((ItemLike)material.getLanternBlock(color)).m_206419_(LanternRecipeProvider.getMaterialLanternTag(material)).m_206419_(LanternRecipeProvider.getColorDyeTag(color)).m_126132_("has_lantern", (CriterionTriggerInstance)LanternRecipeProvider.m_206406_(LanternRecipeProvider.getMaterialLanternTag(material))).m_126140_(recipeConsumer, new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_" + color.getSuffix()));
        }
    }

    private static TagKey<Item> getMaterialLanternTag(LanternMaterial material) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("additionallanterns", material.getSuffix() + "_lanterns"));
    }

    private static TagKey<Item> getColorDyeTag(LanternColor color) {
        return color.dyeColor.getTag();
    }

    private static void addChainRecipe(LanternMaterial material, Consumer<FinishedRecipe> recipeConsumer) {
        if (material.primaryChainIngredient == null && material.secondaryChainIngredient == null) {
            return;
        }
        if (material.primaryChainIngredient == null) {
            ShapedRecipeBuilder.m_126118_((ItemLike)material.getChainBlock(), (int)material.chainRecipeCount).m_126130_("B").m_126130_(" ").m_126130_("B").m_126127_(Character.valueOf('B'), material.secondaryChainIngredient).m_126132_("has_secondary", (CriterionTriggerInstance)LanternRecipeProvider.m_125977_((ItemLike)material.secondaryChainIngredient)).m_176498_(recipeConsumer);
        } else if (material.secondaryChainIngredient == null) {
            ShapedRecipeBuilder.m_126118_((ItemLike)material.getChainBlock(), (int)material.chainRecipeCount).m_126130_("A").m_126127_(Character.valueOf('A'), material.primaryChainIngredient).m_126132_("has_primary", (CriterionTriggerInstance)LanternRecipeProvider.m_125977_((ItemLike)material.primaryChainIngredient)).m_176498_(recipeConsumer);
        } else {
            ShapedRecipeBuilder.m_126118_((ItemLike)material.getChainBlock(), (int)material.chainRecipeCount).m_126130_("B").m_126130_("A").m_126130_("B").m_126127_(Character.valueOf('A'), material.primaryChainIngredient).m_126127_(Character.valueOf('B'), material.secondaryChainIngredient).m_126132_("has_primary", (CriterionTriggerInstance)LanternRecipeProvider.m_125977_((ItemLike)material.primaryChainIngredient)).m_176498_(recipeConsumer);
        }
    }
}

