/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.RecipeGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LanternRecipeGenerator
extends RecipeGenerator {
    public LanternRecipeGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addMaterialRecipes(material);
        }
    }

    private void addMaterialRecipes(LanternMaterial material) {
        this.addLanternRecipe(material);
        if (material.canBeColored) {
            this.addColorRecipe(material, null);
            for (LanternColor color : LanternColor.values()) {
                this.addColorRecipe(material, color);
            }
        }
        if (material.hasChains) {
            this.addChainRecipe(material);
        }
    }

    private void addLanternRecipe(LanternMaterial material) {
        if (material.primaryLanternIngredient == null && material.secondaryLanternIngredient == null) {
            return;
        }
        if (material.primaryLanternIngredient == null) {
            this.shaped((ItemLike)material.getLanternBlock()).pattern("B B").pattern(" C ").pattern("B B").input('B', new ItemLike[]{material.secondaryLanternIngredient}).input('C', new ItemLike[]{() -> Items.f_42000_}).unlockedBy(new ItemLike[]{Items.f_42000_});
        } else if (material.secondaryLanternIngredient == null) {
            this.shaped((ItemLike)material.getLanternBlock()).pattern(" A ").pattern("ACA").pattern(" A ").input('A', new ItemLike[]{material.primaryLanternIngredient}).input('C', new ItemLike[]{() -> Items.f_42000_}).unlockedBy(new ItemLike[]{Items.f_42000_});
        } else {
            this.shaped((ItemLike)material.getLanternBlock()).pattern("BAB").pattern("ACA").pattern("BAB").input('A', new ItemLike[]{material.primaryLanternIngredient}).input('B', new ItemLike[]{material.secondaryLanternIngredient}).input('C', new ItemLike[]{() -> Items.f_42000_}).unlockedBy(new ItemLike[]{Items.f_42000_});
        }
    }

    private void addColorRecipe(LanternMaterial material, LanternColor color) {
        if (color == null) {
            this.shapeless(new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_colorless"), (ItemLike)material.getLanternBlock()).input(LanternRecipeGenerator.getMaterialLanternTag(material)).unlockedBy(LanternRecipeGenerator.getMaterialLanternTag(material));
        } else {
            this.shapeless(new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_" + color.getSuffix()), (ItemLike)material.getLanternBlock(color)).input(LanternRecipeGenerator.getMaterialLanternTag(material)).input(LanternRecipeGenerator.getColorDyeTag(color)).unlockedBy(LanternRecipeGenerator.getMaterialLanternTag(material));
        }
    }

    private static TagKey<Item> getMaterialLanternTag(LanternMaterial material) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("additionallanterns", material.getSuffix() + "_lanterns"));
    }

    private static TagKey<Item> getColorDyeTag(LanternColor color) {
        return color.dyeColor.getTag();
    }

    private void addChainRecipe(LanternMaterial material) {
        if (material.primaryChainIngredient == null && material.secondaryChainIngredient == null) {
            return;
        }
        if (material.primaryChainIngredient == null) {
            this.shaped((ItemLike)material.getChainBlock(), material.chainRecipeCount).pattern("B").pattern(" ").pattern("B").input('B', new ItemLike[]{material.secondaryChainIngredient}).unlockedBy(new ItemLike[]{material.secondaryChainIngredient});
        } else if (material.secondaryChainIngredient == null) {
            this.shaped((ItemLike)material.getChainBlock(), material.chainRecipeCount).pattern("A").input('A', new ItemLike[]{material.primaryChainIngredient}).unlockedBy(new ItemLike[]{material.primaryChainIngredient});
        } else {
            this.shaped((ItemLike)material.getChainBlock(), material.chainRecipeCount).pattern("B").pattern("A").pattern("B").input('A', new ItemLike[]{material.primaryChainIngredient}).input('B', new ItemLike[]{material.secondaryChainIngredient}).unlockedBy(new ItemLike[]{material.primaryChainIngredient});
        }
    }
}

