/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OctopusColorRegistry {
    public static final BlockState FALLBACK_BLOCK = Blocks.f_49992_.m_49966_();
    public static Map<String, Integer> TEXTURES_TO_COLOR = new HashMap<String, Integer>();

    public static int getBlockColor(BlockState stack) {
        String blockName = stack.toString();
        if (TEXTURES_TO_COLOR.get(blockName) != null) {
            return TEXTURES_TO_COLOR.get(blockName);
        }
        int colorizer = -1;
        try {
            colorizer = Minecraft.m_91087_().m_91298_().m_92577_(stack, null, null, 0);
        }
        catch (Exception e) {
            AlexsMobs.LOGGER.warn("Another mod did not use block colorizers correctly.");
        }
        int color = 0xFFFFFF;
        if (colorizer == -1) {
            Object texture = null;
            try {
                Color texColour = OctopusColorRegistry.getAverageColour(OctopusColorRegistry.getTextureAtlas(stack));
                color = texColour.getRGB();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            color = colorizer;
        }
        TEXTURES_TO_COLOR.put(blockName, color);
        return color;
    }

    private static Color getAverageColour(TextureAtlasSprite image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        int uMax = image.m_118405_();
        int vMax = image.m_118408_();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                int alpha = image.getPixelRGBA(0, (int)i, (int)j) >> 24 & 0xFF;
                if (alpha == 0) continue;
                red += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 0 & 0xFF);
                green += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 8 & 0xFF);
                blue += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 16 & 0xFF);
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state).m_6160_();
    }
}

