/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.component.BalmComponents;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeBalmComponents
implements BalmComponents {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public <TComponent> DeferredObject<DataComponentType<TComponent>> registerComponent(Supplier<DataComponentType<TComponent>> supplier, ResourceLocation identifier) {
        DeferredObject<DataComponentType<TComponent>> deferredObject = new DeferredObject<DataComponentType<TComponent>>(identifier, () -> {
            DataComponentType dataComponentType = (DataComponentType)supplier.get();
            Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)identifier, (Object)dataComponentType);
            return dataComponentType;
        });
        this.getActiveRegistrations().dataComponentTypes.add(deferredObject);
        return deferredObject;
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final List<DeferredObject<?>> dataComponentTypes = new ArrayList();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> this.dataComponentTypes.forEach(DeferredObject::resolve));
        }
    }
}

