/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.world;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.blay09.mods.balm.forge.world.BalmBiomeModifier;
import net.blay09.mods.balm.forge.world.BiomeModification;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgeBalmWorldGen
implements BalmWorldGen {
    public static final MapCodec<BalmBiomeModifier> BALM_BIOME_MODIFIER_CODEC = MapCodec.unit((Object)BalmBiomeModifier.INSTANCE);
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();
    private static final List<BiomeModification> biomeModifications = new ArrayList<BiomeModification>();

    public ForgeBalmWorldGen() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public <T extends Feature<?>> DeferredObject<T> registerFeature(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.FEATURES, identifier.getNamespace());
        RegistryObject registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <T extends PlacementModifierType<?>> DeferredObject<T> registerPlacementModifier(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredObject<PlacementModifierType> deferredObject = new DeferredObject<PlacementModifierType>(identifier, () -> {
            PlacementModifierType placementModifierType = (PlacementModifierType)supplier.get();
            Registry.register((Registry)BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, (ResourceLocation)identifier, (Object)placementModifierType);
            return placementModifierType;
        });
        this.getActiveRegistrations().placementModifiers.add(deferredObject);
        return deferredObject;
    }

    @Override
    public void addFeatureToBiomes(BiomePredicate biomePredicate, GenerationStep.Decoration step, ResourceLocation placedFeatureIdentifier) {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)placedFeatureIdentifier);
        biomeModifications.add(new BiomeModification(biomePredicate, step, (ResourceKey<PlacedFeature>)resourceKey));
    }

    public void modifyBiome(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            for (BiomeModification biomeModification : biomeModifications) {
                ResourceLocation location = biome.unwrapKey().map(ResourceKey::location).orElse(null);
                if (location == null || !biomeModification.getBiomePredicate().test(location, biome)) continue;
                Registry placedFeatures = ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
                placedFeatures.getHolder(biomeModification.getConfiguredFeatureKey()).ifPresent(placedFeature -> builder.getGenerationSettings().addFeature(biomeModification.getStep(), (Holder)placedFeature));
            }
        }
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    public static void initializeBalmBiomeModifiers() {
        DeferredRegister registry = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"balm");
        registry.register("balm", () -> BALM_BIOME_MODIFIER_CODEC);
        registry.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static class Registrations {
        public final List<DeferredObject<?>> configuredFeatures = new ArrayList();
        public final List<DeferredObject<?>> placedFeatures = new ArrayList();
        public final List<DeferredObject<?>> placementModifiers = new ArrayList();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                this.placementModifiers.forEach(DeferredObject::resolve);
                this.configuredFeatures.forEach(DeferredObject::resolve);
                this.placedFeatures.forEach(DeferredObject::resolve);
            });
        }
    }
}

