/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ForgeRenderTypes;
import org.joml.Matrix4f;

public class BOScreen
extends Screen {
    protected double renderScale = 1.0;
    protected double mcScale = 1.0;
    protected BOWindow window;
    protected double x = 0.0;
    protected double y = 0.0;
    public static boolean isMouseLeftDown = false;
    protected boolean isOpen = false;
    protected int framebufferWidth;
    protected int framebufferHeight;
    protected int absoluteMouseX;
    protected int absoluteMouseY;

    public BOScreen(BOWindow w) {
        super((Component)Component.m_237113_((String)"Blockout GUI"));
        this.window = w;
    }

    public void m_88315_(GuiGraphics ms, int mx, int my, float f) {
        if (this.f_96541_ == null || !this.isOpen) {
            return;
        }
        this.absoluteMouseX = mx;
        this.absoluteMouseY = my;
        this.framebufferWidth = ms.f_279544_.m_91268_().m_85441_();
        this.framebufferHeight = ms.f_279544_.m_91268_().m_85442_();
        int guiWidth = Math.max(this.framebufferWidth, 320);
        int guiHeight = Math.max(this.framebufferHeight, 240);
        boolean oldFilteringValue = ForgeRenderTypes.enableTextTextureLinearFiltering;
        ForgeRenderTypes.enableTextTextureLinearFiltering = false;
        this.mcScale = ms.f_279544_.m_91268_().m_85449_();
        this.renderScale = this.window.getRenderType().calcRenderScale(ms.f_279544_.m_91268_(), this.window);
        if (this.window.hasLightbox()) {
            this.f_96543_ = this.framebufferWidth;
            this.f_96544_ = this.framebufferHeight;
            super.m_280273_(ms);
        }
        this.f_96543_ = this.window.getWidth();
        this.f_96544_ = this.window.getHeight();
        this.x = Math.floor(((double)guiWidth - (double)this.f_96543_ * this.renderScale) / 2.0);
        this.y = Math.floor(((double)guiHeight - (double)this.f_96544_ * this.renderScale) / 2.0);
        PoseStack shaderPs = RenderSystem.getModelViewStack();
        Matrix4f oldProjection = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)this.framebufferWidth, (float)this.framebufferHeight, 0.0f, -10000.0f, 50000.0f), (VertexSorting)VertexSorting.f_276633_);
        shaderPs.m_85836_();
        shaderPs.m_166856_();
        PoseStack newMs = new PoseStack();
        newMs.m_85837_(this.x, this.y, 0.0);
        newMs.m_85841_((float)this.renderScale, (float)this.renderScale, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        try {
            BOGuiGraphics target = new BOGuiGraphics(ms.f_279544_, newMs, ms.m_280091_());
            this.window.draw(target, this.calcRelativeX(mx), this.calcRelativeY(my));
            target.applyCursor();
            this.window.drawLast(target, this.calcRelativeX(mx), this.calcRelativeY(my));
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Rendering BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen rendering details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Scaling mode (window render type)", () -> this.window.getRenderType().name());
            category.m_128165_("Vanilla gui scale", () -> Double.toString(this.mcScale));
            category.m_128165_("BO gui scale", () -> Double.toString(this.renderScale));
            throw new ReportedException(crashReport);
        }
        finally {
            shaderPs.m_85849_();
            RenderSystem.setProjectionMatrix((Matrix4f)oldProjection, (VertexSorting)VertexSorting.f_276633_);
            RenderSystem.applyModelViewMatrix();
            ForgeRenderTypes.enableTextTextureLinearFiltering = oldFilteringValue;
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key >= 0 && key <= 348) {
            try {
                return this.window.onKeyTyped('\u0000', key);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"KeyPressed event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen key event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("GLFW key value", () -> Integer.toString(key));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean m_5534_(char ch, int key) {
        try {
            return this.window.onKeyTyped(ch, key);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"CharTyped event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen char event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Char value", () -> Character.toString(ch));
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_6375_(double mxIn, double myIn, int keyCode) {
        double mx = this.calcRelativeX(mxIn);
        double my = this.calcRelativeY(myIn);
        try {
            if (keyCode == 0) {
                isMouseLeftDown = true;
                return this.window.click(mx, my);
            }
            if (keyCode == 1) {
                return this.window.rightClick(mx, my);
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MousePressed event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("GLFW mouse key value", () -> Integer.toString(keyCode));
            throw new ReportedException(crashReport);
        }
        return false;
    }

    public boolean m_6050_(double mx, double my, double scrollDiff) {
        if (scrollDiff != 0.0) {
            try {
                return this.window.scrollInput(scrollDiff * 10.0, this.calcRelativeX(mx), this.calcRelativeY(my));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseScroll event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen scroll event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("Scroll value", () -> Double.toString(scrollDiff));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean m_7979_(double xIn, double yIn, int speed, double deltaX, double deltaY) {
        try {
            return this.window.onMouseDrag(this.calcRelativeX(xIn), this.calcRelativeY(yIn), speed, deltaX, deltaY);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseDragged event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_6348_(double mxIn, double myIn, int keyCode) {
        if (keyCode == 0) {
            isMouseLeftDown = false;
            try {
                return this.window.onMouseReleased(this.calcRelativeX(mxIn), this.calcRelativeY(myIn));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseReleased event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("GLFW mouse key value", () -> Integer.toString(keyCode));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public BOWindow getWindow() {
        return this.window;
    }

    public void m_86600_() {
        try {
            if (this.f_96541_ != null) {
                if (!this.isOpen) {
                    this.window.onOpened();
                    this.isOpen = true;
                } else {
                    LocalPlayer player;
                    this.window.onUpdate();
                    LocalPlayer localPlayer = player = this.f_96541_ == null ? null : this.f_96541_.f_91074_;
                    if (player != null && (!player.m_6084_() || player.f_20890_)) {
                        player.m_6915_();
                    }
                }
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Ticking/Updating BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen update details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
    }

    public void m_7861_() {
        try {
            this.window.onClosed();
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Closing BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen closing details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
        finally {
            BOWindow.clearFocus();
        }
    }

    public boolean m_7043_() {
        return this.window.doesWindowPauseGame();
    }

    private double calcRelativeX(double xIn) {
        return (xIn * this.mcScale - this.x) / this.renderScale;
    }

    private double calcRelativeY(double yIn) {
        return (yIn * this.mcScale - this.y) / this.renderScale;
    }

    public double getRenderScale() {
        return this.renderScale;
    }

    public double getVanillaGuiScale() {
        return this.mcScale;
    }

    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public int getAbsoluteMouseX() {
        return this.absoluteMouseX;
    }

    public int getAbsoluteMouseY() {
        return this.absoluteMouseY;
    }
}

