/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIcon
extends Pane {
    private static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    private static final MutableComponent FIX_VANILLA_TOOLTIP = SpacerTextComponent.of(1);
    private ItemStack itemStack;

    public ItemIcon() {
    }

    public ItemIcon(PaneParams params) {
        super(params);
        Item item;
        String itemName = params.getString("item");
        if (itemName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))) != null) {
            this.setItem(item.m_7968_());
        }
    }

    public void setItem(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
        Pane pane = this.onHover;
        if (pane instanceof Tooltip) {
            Tooltip tooltip = (Tooltip)pane;
            tooltip.setTextOld(this.getModifiedItemStackTooltip());
        }
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        if (this.itemStack != null && !this.itemStack.m_41619_()) {
            ms.m_85836_();
            ms.m_252880_((float)this.x, (float)this.y, 0.0f);
            ms.m_85841_((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
            target.m_280480_(this.itemStack, 0, 0);
            target.renderItemDecorations(this.itemStack, 0, 0);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            ms.m_85849_();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && this.itemStack != null && !this.itemStack.m_41619_()) {
            PaneBuilders.tooltipBuilder().hoverPane(this).build().setTextOld(this.getModifiedItemStackTooltip());
        }
    }

    public List<Component> getModifiedItemStackTooltip() {
        TooltipFlag.Default tooltipFlags;
        if (this.itemStack == null) {
            return Collections.emptyList();
        }
        TooltipFlag.Default default_ = tooltipFlags = this.mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        if (this.mc.f_91074_.m_7500_()) {
            tooltipFlags = tooltipFlags.m_257777_();
        }
        List result = this.itemStack.m_41651_((Player)this.mc.f_91074_, (TooltipFlag)tooltipFlags);
        ItemStack defaultStack = this.itemStack.m_41720_().m_7968_();
        if (tooltipFlags.f_43368_() && tooltipFlags.f_257043_()) {
            ForgeRegistries.ITEMS.getHolder((Object)this.itemStack.m_41720_()).map(Holder::getTagKeys).ifPresent(tags -> tags.forEach(tag -> result.add(1, ItemIcon.wrapShift(Component.m_237113_((String)("#" + tag.f_203868_())).m_130940_(ChatFormatting.DARK_PURPLE)))));
            int i = 1;
            for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
                if (!tab.m_257694_(defaultStack)) continue;
                result.add(i++, ItemIcon.wrapShift(tab.m_40786_().m_6881_().m_130940_(ChatFormatting.BLUE)));
            }
        }
        result.add(1, FIX_VANILLA_TOOLTIP);
        return result;
    }

    private static MutableComponent wrapShift(MutableComponent wrapped) {
        return ToggleableTextComponent.of(Screen::m_96638_, wrapped);
    }
}

