/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.resloc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jetbrains.annotations.Nullable;

public class OutOfJarResourceLocation
extends ResourceLocation {
    private final Path nioPath;

    protected OutOfJarResourceLocation(String namespace, Path path, @Nullable String pathString) {
        super(namespace, pathString != null ? pathString : path.toString().toLowerCase().replace('\\', '/').replaceAll("[^a-z0-9/._-]", "_"));
        this.nioPath = path;
    }

    public static OutOfJarResourceLocation of(String namespace, Path path) {
        return new OutOfJarResourceLocation(namespace, path, null);
    }

    public static OutOfJarResourceLocation ofMinecraftFolder(String namespace, String ... parts) {
        Path path = Minecraft.m_91087_().f_91069_.toPath().resolve(namespace);
        for (String part : parts) {
            path = path.resolve(part);
        }
        return OutOfJarResourceLocation.of(namespace, path);
    }

    public Path getNioPath() {
        return this.nioPath;
    }

    public static boolean fileExists(ResourceLocation resLoc, ResourceManager fallbackManager) {
        if (resLoc instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)resLoc;
            return Files.exists(nioResLoc.nioPath, new LinkOption[0]);
        }
        return fallbackManager.m_213713_(resLoc).isPresent();
    }

    public static Resource getResourceHandle(ResourceLocation resLoc, ResourceManager fallbackManager) {
        if (resLoc instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)resLoc;
            return OutOfJarResourceLocation.fileExists(nioResLoc.m_266382_(".mcmeta"), fallbackManager) ? new OutOfJarResource(nioResLoc, (IoSupplier<ResourceMetadata>)FallbackResourceManager.m_245722_(() -> Files.newInputStream(nioResLoc.getNioPath(), new OpenOption[0]))) : new OutOfJarResource(nioResLoc);
        }
        return (Resource)fallbackManager.m_213713_(resLoc).orElseThrow(() -> new RuntimeException("File not found: " + resLoc));
    }

    public static InputStream openStream(ResourceLocation resLoc, ResourceManager fallbackManager) throws IOException {
        if (resLoc instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)resLoc;
            return Files.newInputStream(nioResLoc.nioPath, new OpenOption[0]);
        }
        return fallbackManager.m_215595_(resLoc);
    }

    public static BufferedReader openReader(ResourceLocation resLoc, ResourceManager fallbackManager) throws IOException {
        if (resLoc instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)resLoc;
            return Files.newBufferedReader(nioResLoc.nioPath);
        }
        return fallbackManager.m_215597_(resLoc);
    }

    @Deprecated(forRemoval=false)
    public ResourceLocation m_247449_(String path) {
        return OutOfJarResourceLocation.of(this.m_135827_(), Path.of(path, new String[0]));
    }

    @Deprecated(forRemoval=false)
    public ResourceLocation m_247266_(UnaryOperator<String> op) {
        return OutOfJarResourceLocation.of(this.m_135827_(), Path.of((String)op.apply(this.nioPath.toString()), new String[0]));
    }

    public ResourceLocation m_246208_(String prefix) {
        return OutOfJarResourceLocation.of(this.m_135827_(), Path.of(prefix, new String[0]).resolve(this.nioPath));
    }

    public ResourceLocation m_266382_(String suffix) {
        return OutOfJarResourceLocation.of(this.m_135827_(), this.nioPath.resolveSibling(this.nioPath.getFileName().toString() + suffix));
    }

    public int compareNamespaced(ResourceLocation o) {
        if (o instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)o;
            int ret = this.m_135827_().compareTo(nioResLoc.m_135827_());
            return ret != 0 ? ret : this.nioPath.compareTo(nioResLoc.nioPath);
        }
        return super.compareNamespaced(o);
    }

    public int compareTo(ResourceLocation o) {
        if (o instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)o;
            int ret = this.nioPath.compareTo(nioResLoc.nioPath);
            return ret != 0 ? ret : this.m_135827_().compareTo(nioResLoc.m_135827_());
        }
        return super.compareTo(o);
    }

    public int hashCode() {
        return 31 * this.m_135827_().hashCode() + this.nioPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)((Object)obj);
            return this.m_135827_().equals(nioResLoc.m_135827_()) && this.nioPath.equals(nioResLoc.nioPath);
        }
        return false;
    }

    public static class OutOfJarResource
    extends Resource {
        private final OutOfJarResourceLocation resLoc;

        public OutOfJarResource(OutOfJarResourceLocation resLoc, IoSupplier<ResourceMetadata> metadataSupplier) {
            super(null, () -> Files.newInputStream(resLoc.getNioPath(), new OpenOption[0]), metadataSupplier);
            this.resLoc = resLoc;
        }

        public OutOfJarResource(OutOfJarResourceLocation resLoc) {
            super(null, () -> Files.newInputStream(resLoc.getNioPath(), new OpenOption[0]));
            this.resLoc = resLoc;
        }

        public PackResources m_247173_() {
            return null;
        }

        public String m_215506_() {
            return "blockui out-of-jar resource: " + this.resLoc;
        }

        public boolean m_247137_() {
            return false;
        }
    }
}

