/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.texture;

import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.util.texture.IsOurTexture;
import com.ldtteam.blockui.util.texture.SpriteTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class OutOfJarTexture
extends AbstractTexture {
    protected final OutOfJarResourceLocation resourceLocation;
    private boolean redirectToSprite = false;

    public OutOfJarTexture(OutOfJarResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        NativeImage nativeImage;
        if (!OutOfJarResourceLocation.fileExists(this.resourceLocation, resourceManager)) {
            throw new FileNotFoundException(this.resourceLocation.toString());
        }
        Resource resource = OutOfJarResourceLocation.getResourceHandle(this.resourceLocation, resourceManager);
        if (resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).isPresent()) {
            this.redirectToSprite = true;
            throw new IOException("Vanilla hack: redirecting loading to sprite texture, do NOT report this exception, it IS intended");
        }
        TextureMetadataSection textureMeta = resource.m_215509_().m_214059_((MetadataSectionSerializer)TextureMetadataSection.f_119108_).orElse(null);
        try (InputStream is = resource.m_215507_();){
            nativeImage = NativeImage.m_85058_((InputStream)is);
        }
        TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)nativeImage.m_84982_(), (int)nativeImage.m_85084_());
        if (textureMeta != null) {
            nativeImage.m_85013_(0, 0, 0, 0, 0, nativeImage.m_84982_(), nativeImage.m_85084_(), textureMeta.m_119115_(), textureMeta.m_119116_(), false, true);
        } else {
            nativeImage.m_85040_(0, 0, 0, true);
        }
    }

    public static void assertLoaded(OutOfJarResourceLocation resourceLocation, TextureManager textureManager) {
        AbstractTexture current = textureManager.m_174786_((ResourceLocation)resourceLocation, null);
        if (!IsOurTexture.isOur(current)) {
            OutOfJarTexture outOfJarTexture = new OutOfJarTexture(resourceLocation);
            textureManager.m_118495_((ResourceLocation)resourceLocation, (AbstractTexture)outOfJarTexture);
            if (outOfJarTexture.redirectToSprite) {
                textureManager.m_118495_((ResourceLocation)resourceLocation, (AbstractTexture)new SpriteTexture(resourceLocation));
            }
        }
    }
}

