/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.MouseEventCallback;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.util.cursor.Cursor;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;

public class ZoomDragView
extends View {
    protected double scrollX = 0.0;
    protected double scrollY = 0.0;
    protected double scale = 1.0;
    protected int contentHeight = 0;
    protected int contentWidth = 0;
    protected double dragFactor = 1.0;
    protected boolean dragEnabled = true;
    protected double zoomFactor = 1.1;
    protected boolean zoomEnabled = true;
    protected double minScale = 0.2;
    protected double maxScale = 2.0;

    public ZoomDragView() {
        this.cursor = Cursor.RESIZE;
    }

    public ZoomDragView(PaneParams params) {
        super(params);
        this.dragFactor = params.getDouble("dragfactor", this.dragFactor);
        this.dragEnabled = params.getBoolean("dragenabled", this.dragEnabled);
        this.zoomFactor = params.getDouble("zoomfactor", this.zoomFactor);
        this.zoomEnabled = params.getBoolean("zoomenabled", this.zoomEnabled);
        this.minScale = params.getDouble("minscale", this.minScale);
        this.maxScale = params.getDouble("maxscale", this.maxScale);
        this.cursor = this.cursor == Cursor.DEFAULT ? Cursor.RESIZE : this.cursor;
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return this.calcInverseAbsoluteX(child.getX()) < (double)this.getInteriorWidth() && this.calcInverseAbsoluteY(child.getY()) < (double)this.getInteriorHeight() && this.calcInverseAbsoluteX(child.getX() + child.getWidth()) >= 0.0 && this.calcInverseAbsoluteY(child.getY() + child.getHeight()) >= 0.0;
    }

    @Override
    public Cursor getCursor() {
        Cursor superCursor = super.getCursor();
        if (superCursor != Cursor.RESIZE) {
            return superCursor;
        }
        if (this.getMaxScrollX() == 0.0) {
            superCursor = Cursor.VERTICAL_RESIZE;
        }
        if (this.getMaxScrollY() == 0.0) {
            superCursor = superCursor == Cursor.RESIZE ? Cursor.HORIZONTAL_RESIZE : Cursor.DEFAULT;
        }
        return superCursor;
    }

    public double calcInverseAbsoluteX(double xIn) {
        return xIn * this.scale - this.scrollX;
    }

    public double calcInverseAbsoluteY(double yIn) {
        return yIn * this.scale - this.scrollY;
    }

    public double calcRelativeX(double xIn) {
        return (xIn - (double)this.x + this.scrollX) / this.scale + (double)this.x;
    }

    public double calcRelativeY(double yIn) {
        return (yIn - (double)this.y + this.scrollY) / this.scale + (double)this.y;
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentSize();
    }

    @Override
    public void addChild(Pane child) {
        super.addChild(child);
        this.computeContentSize();
    }

    public void computeContentSize() {
        this.contentHeight = 0;
        this.contentWidth = 0;
        for (Pane child : this.children) {
            if (child == null) continue;
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
            this.contentWidth = Math.max(this.contentWidth, child.getX() + child.getWidth());
        }
        this.setScrollY(this.scrollY);
        this.setScrollX(this.scrollX);
    }

    public double getMaxScrollY() {
        return Math.max(0.0, (double)this.contentHeight * this.scale - (double)this.getHeight());
    }

    public double getMaxScrollX() {
        return Math.max(0.0, (double)this.contentWidth * this.scale - (double)this.getWidth());
    }

    protected void abstractDrawSelfPre(PoseStack ms, double mx, double my) {
    }

    protected void abstractDrawSelfPost(PoseStack ms, double mx, double my) {
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        this.scissorsStart(ms, this.contentWidth, this.contentHeight);
        ms.m_85836_();
        ms.m_85837_(-this.scrollX, -this.scrollY, 0.0);
        ms.m_85837_((1.0 - this.scale) * (double)this.x, (1.0 - this.scale) * (double)this.y, 0.0);
        ms.m_85841_((float)this.scale, (float)this.scale, 1.0f);
        this.abstractDrawSelfPre(ms, mx, my);
        super.drawSelf(target, this.calcRelativeX(mx), this.calcRelativeY(my));
        this.abstractDrawSelfPost(ms, mx, my);
        ms.m_85849_();
        this.scissorsEnd(target);
    }

    @Override
    public void drawSelfLast(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        this.scissorsStart(ms, this.contentWidth, this.contentHeight);
        ms.m_85836_();
        ms.m_85837_(-this.scrollX, -this.scrollY, 0.0);
        ms.m_85837_((1.0 - this.scale) * (double)this.x, (1.0 - this.scale) * (double)this.y, 0.0);
        ms.m_85841_((float)this.scale, (float)this.scale, 1.0f);
        super.drawSelfLast(target, this.calcRelativeX(mx), this.calcRelativeY(my));
        ms.m_85849_();
        this.scissorsEnd(target);
    }

    public void setScrollY(double offset) {
        this.scrollY = Mth.m_14008_((double)offset, (double)0.0, (double)this.getMaxScrollY());
    }

    public void setScrollX(double offset) {
        this.scrollX = Mth.m_14008_((double)offset, (double)0.0, (double)this.getMaxScrollX());
    }

    @Override
    public boolean onMouseDrag(double startX, double startY, int speed, double x, double y) {
        boolean childResult = super.onMouseDrag(startX, startY, speed, this.calcRelativeX(x), this.calcRelativeY(y));
        if (!childResult && this.dragEnabled) {
            this.setScrollX(this.scrollX - x * this.dragFactor);
            this.setScrollY(this.scrollY - y * this.dragFactor);
            return true;
        }
        return childResult;
    }

    @Override
    public boolean scrollInput(double wheel, double mx, double my) {
        boolean childResult = super.scrollInput(wheel, mx, my);
        if (!childResult && this.zoomEnabled) {
            double childX = mx - (double)this.x;
            double childY = my - (double)this.y;
            double oldX = (childX + this.scrollX) / this.scale;
            double oldY = (childY + this.scrollY) / this.scale;
            this.scale = wheel < 0.0 ? this.scale / this.zoomFactor : this.scale * this.zoomFactor;
            this.scale = Mth.m_14008_((double)this.scale, (double)this.minScale, (double)this.maxScale);
            this.setScrollX(oldX * this.scale - childX);
            this.setScrollY(oldY * this.scale - childY);
            return true;
        }
        return childResult;
    }

    @Override
    public boolean mouseEventProcessor(double mx, double my, MouseEventCallback panePredicate, MouseEventCallback eventCallbackPositive, MouseEventCallback eventCallbackNegative) {
        return super.mouseEventProcessor(this.calcRelativeX(mx), this.calcRelativeY(my), panePredicate, eventCallbackPositive, eventCallbackNegative);
    }

    public void addChildPlain(Pane child) {
        super.addChild(child);
    }

    public double getDragFactor() {
        return this.dragFactor;
    }

    public void setDragFactor(double dragFactor) {
        if (dragFactor < 1.0) {
            throw new IllegalArgumentException("dragFactor can't be less than one");
        }
        this.dragFactor = dragFactor;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void enableDrag() {
        this.setDragEnabled(true);
    }

    public void disableDrag() {
        this.setDragEnabled(false);
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        if (zoomFactor < 1.0) {
            throw new IllegalArgumentException("zoomFactor can't be less than one");
        }
        this.zoomFactor = zoomFactor;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void enableZoom() {
        this.setZoomEnabled(true);
    }

    public void disableZoom() {
        this.setZoomEnabled(false);
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double minScale) {
        if (minScale > this.maxScale) {
            throw new IllegalArgumentException("minScale can't be greater than maxScale");
        }
        this.minScale = minScale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double maxScale) {
        if (maxScale < this.minScale) {
            throw new IllegalArgumentException("maxScale can't be less than minScale");
        }
        this.maxScale = maxScale;
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    public void setScaleRaw(double scale) {
        this.scale = Mth.m_14008_((double)scale, (double)this.minScale, (double)this.maxScale);
    }

    public double getScale() {
        return this.scale;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }
}

