/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.arcade.games;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrh0.buildersaddition.arcade.ArcadeGame;
import com.mrh0.buildersaddition.arcade.ArcadeScreen;
import com.mrh0.buildersaddition.tileentity.ArcadeTileEntity;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.Gui;

public class ArcadeBreakout
extends ArcadeGame {
    final int padWidth = 6;
    final float padSpeed = 1.0f;
    final float ballSpeed = 1.0f;
    final ArrayList<Ball> balls = new ArrayList();

    public ArcadeBreakout(ArcadeScreen s, ArcadeTileEntity te) {
        super(s, te);
    }

    @Override
    public void start() {
        super.start();
        this.s.clear();
        this.balls.add(new Ball(this.s.width / 2, this.s.height / 2));
        this.s.setFgRenderer(this::fgRender);
        this.s.setColors(0, 15);
        this.s.print(0, "Work in progress.");
    }

    private void fgRender(PoseStack stack, int x, int y, int width, int height) {
        for (Ball b : this.balls) {
            b.render(stack, x, y, width, height);
        }
    }

    @Override
    public void frame(long time) {
        super.frame(time);
        for (Ball b : this.balls) {
            b.update();
        }
    }

    private class Ball {
        public float x;
        public float y;
        public float vx = 0.0f;
        public float vy = 0.0f;

        public Ball(int x, int y) {
            this.x = x;
            this.y = y;
            this.setVelocityAngle((float)Math.random() * 360.0f, 1.0f);
        }

        public void update() {
            this.x += this.vx;
            this.y += this.vy;
            if (this.x + this.vx <= 0.0f) {
                this.x = 0.0f;
                this.bounceVertical();
            }
            if (this.y + this.vy <= 0.0f) {
                this.y = 0.0f;
                this.bounceHorizontal();
            }
            if (this.x + this.vx >= (float)(ArcadeBreakout.this.s.width - 1)) {
                this.x = ArcadeBreakout.this.s.width - 1;
                this.bounceVertical();
            }
            if (this.y + this.vy >= (float)(ArcadeBreakout.this.s.height - 1)) {
                this.y = ArcadeBreakout.this.s.height - 1;
                this.bounceHorizontal();
            }
        }

        public void render(PoseStack stack, int sx, int sy, int swidth, int sheight) {
            Objects.requireNonNull(ArcadeBreakout.this.s);
            int n = sx + (int)(this.x * 8.0f);
            Objects.requireNonNull(ArcadeBreakout.this.s);
            int n2 = sy + (int)(this.y * 8.0f);
            Objects.requireNonNull(ArcadeBreakout.this.s);
            Objects.requireNonNull(ArcadeBreakout.this.s);
            int n3 = sx + 8 + (int)(this.x * 8.0f);
            Objects.requireNonNull(ArcadeBreakout.this.s);
            Objects.requireNonNull(ArcadeBreakout.this.s);
            Gui.m_93172_((PoseStack)stack, (int)n, (int)n2, (int)n3, (int)(sy + 8 + (int)(this.y * 8.0f)), (int)ArcadeScreen.getRenderColor(10));
        }

        public int getX() {
            return (int)this.x;
        }

        public int getY() {
            return (int)this.y;
        }

        public void bounceVertical() {
            this.vx = -this.vx;
            ArcadeBreakout.this.playSound(12, 0);
        }

        public void bounceHorizontal() {
            this.vy = -this.vy;
            ArcadeBreakout.this.playSound(12, 0);
        }

        public void setVelocity(float x, float y) {
            this.vx = x;
            this.vy = y;
        }

        public void setVelocityAngle(float angle, float v) {
            this.setVelocity((float)Math.cos(Math.toRadians(angle)) * v, (float)Math.sin(Math.toRadians(angle)) * v);
        }
    }
}

