/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.state.ShopSignState;
import com.mrh0.buildersaddition.tileentity.ShopSignTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShopSign
extends BaseDerivativeBlock
implements EntityBlock {
    public static final EnumProperty<ShopSignState> STATE = EnumProperty.m_61587_((String)"state", ShopSignState.class);
    private static VoxelShape SHAPE_DOWN_X = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)14.0, (double)6.0, (double)4.0, (double)16.0, (double)10.0), Block.m_49796_((double)12.0, (double)14.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0)});
    private static VoxelShape SHAPE_DOWN_Z = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)14.0, (double)2.0, (double)10.0, (double)16.0, (double)4.0), Block.m_49796_((double)6.0, (double)14.0, (double)12.0, (double)10.0, (double)16.0, (double)14.0)});
    private static VoxelShape SHAPE_UP_X = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)2.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)4.0, (double)2.0, (double)10.0), Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)14.0, (double)2.0, (double)10.0)});
    private static VoxelShape SHAPE_UP_Z = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)2.0, (double)1.0, (double)9.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0, (double)4.0), Block.m_49796_((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)2.0, (double)14.0)});
    private static VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)4.0, (double)16.0), Block.m_49796_((double)6.0, (double)12.0, (double)14.0, (double)10.0, (double)14.0, (double)16.0)});
    private static VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)1.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)2.0, (double)6.0, (double)2.0, (double)4.0, (double)10.0), Block.m_49796_((double)0.0, (double)12.0, (double)6.0, (double)2.0, (double)14.0, (double)10.0)});
    private static VoxelShape SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)1.0, (double)2.0, (double)9.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)4.0, (double)2.0), Block.m_49796_((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)14.0, (double)2.0)});
    private static VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)7.0, (double)14.0, (double)15.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)2.0, (double)6.0, (double)16.0, (double)4.0, (double)10.0), Block.m_49796_((double)14.0, (double)12.0, (double)6.0, (double)16.0, (double)14.0, (double)10.0)});
    private static VoxelShape SHAPE_NORTH_PILLAR = SHAPE_NORTH.m_83216_(0.0, 0.0, 0.125);
    private static VoxelShape SHAPE_EAST_PILLAR = SHAPE_EAST.m_83216_(-0.125, 0.0, 0.0);
    private static VoxelShape SHAPE_SOUTH_PILLAR = SHAPE_SOUTH.m_83216_(0.0, 0.0, -0.125);
    private static VoxelShape SHAPE_WEST_PILLAR = SHAPE_WEST.m_83216_(0.125, 0.0, 0.0);
    private static VoxelShape SHAPE_NORTH_FENCE = SHAPE_NORTH.m_83216_(0.0, 0.0, 0.375);
    private static VoxelShape SHAPE_EAST_FENCE = SHAPE_EAST.m_83216_(-0.375, 0.0, 0.0);
    private static VoxelShape SHAPE_SOUTH_FENCE = SHAPE_SOUTH.m_83216_(0.0, 0.0, -0.375);
    private static VoxelShape SHAPE_WEST_FENCE = SHAPE_WEST.m_83216_(0.375, 0.0, 0.0);
    private static VoxelShape SHAPE_NORTH_WALL = SHAPE_NORTH.m_83216_(0.0, 0.0, 0.25);
    private static VoxelShape SHAPE_EAST_WALL = SHAPE_EAST.m_83216_(-0.25, 0.0, 0.0);
    private static VoxelShape SHAPE_SOUTH_WALL = SHAPE_SOUTH.m_83216_(0.0, 0.0, -0.25);
    private static VoxelShape SHAPE_WEST_WALL = SHAPE_WEST.m_83216_(0.25, 0.0, 0.0);

    public ShopSign(String name) {
        super("shop_sign_" + name, Blocks.f_50011_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)ShopSignState.getFor(c.m_43719_(), c.m_8125_().m_122427_(), c.m_8083_(), c.m_43725_())));
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape((ShopSignState)((Object)state.m_61143_(STATE)));
    }

    public VoxelShape getShape(ShopSignState state) {
        switch (state) {
            case Up_X: {
                return SHAPE_UP_X;
            }
            case Up_Z: {
                return SHAPE_UP_Z;
            }
            case Down_X: {
                return SHAPE_DOWN_X;
            }
            case Down_Z: {
                return SHAPE_DOWN_Z;
            }
            case North: {
                return SHAPE_NORTH;
            }
            case East: {
                return SHAPE_EAST;
            }
            case South: {
                return SHAPE_SOUTH;
            }
            case West: {
                return SHAPE_WEST;
            }
            case North_Pillar: {
                return SHAPE_NORTH_PILLAR;
            }
            case East_Pillar: {
                return SHAPE_EAST_PILLAR;
            }
            case South_Pillar: {
                return SHAPE_SOUTH_PILLAR;
            }
            case West_Pillar: {
                return SHAPE_WEST_PILLAR;
            }
            case North_Wall: {
                return SHAPE_NORTH_WALL;
            }
            case East_Wall: {
                return SHAPE_EAST_WALL;
            }
            case South_Wall: {
                return SHAPE_SOUTH_WALL;
            }
            case West_Wall: {
                return SHAPE_WEST_WALL;
            }
            case North_Fence: {
                return SHAPE_NORTH_FENCE;
            }
            case East_Fence: {
                return SHAPE_EAST_FENCE;
            }
            case South_Fence: {
                return SHAPE_SOUTH_FENCE;
            }
            case West_Fence: {
                return SHAPE_WEST_FENCE;
            }
        }
        return SHAPE_UP_Z;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof ShopSignTileEntity) {
            ShopSignTileEntity sste = (ShopSignTileEntity)te;
            ItemStack heald = player.m_21120_(hand);
            if (player.m_6047_()) {
                if (!player.m_7500_()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)sste.getDisplayItem());
                }
                sste.setDisplayItem(ItemStack.f_41583_);
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return InteractionResult.CONSUME;
            }
            if (heald != ItemStack.f_41583_) {
                if (sste.hasDisplayItem()) {
                    return InteractionResult.PASS;
                }
                sste.setDisplayItem(heald);
                if (!player.m_7500_()) {
                    heald.m_41774_(1);
                }
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            if (te instanceof ShopSignTileEntity) {
                ShopSignTileEntity sste = (ShopSignTileEntity)te;
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)sste.getDisplayItem());
            }
            te.m_7651_();
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShopSignTileEntity(pos, state);
    }
}

