/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.state.MountState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SupportBracket
extends BaseDerivativeBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final DirectionProperty SUPPORTING = DirectionProperty.m_61546_((String)"supporting", p -> p == Direction.UP || p == Direction.DOWN);
    public static final EnumProperty<MountState> MOUNT = EnumProperty.m_61587_((String)"mount", MountState.class);
    protected static final VoxelShape SHAPE_UP_SOUTH = Block.m_49796_((double)6.0, (double)4.0, (double)4.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP_NORTH = Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_UP_EAST = Block.m_49796_((double)4.0, (double)4.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST = Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_DOWN_NORTH = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_DOWN_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)12.0, (double)12.0, (double)10.0);
    static int o1 = 2;
    protected static final VoxelShape SHAPE_UP_SOUTH_PILLAR = Block.m_49796_((double)6.0, (double)4.0, (double)(4.0 + (double)o1), (double)10.0, (double)16.0, (double)(16.0 + (double)o1));
    protected static final VoxelShape SHAPE_UP_NORTH_PILLAR = Block.m_49796_((double)6.0, (double)4.0, (double)(0.0 - (double)o1), (double)10.0, (double)16.0, (double)(12.0 - (double)o1));
    protected static final VoxelShape SHAPE_UP_EAST_PILLAR = Block.m_49796_((double)(4.0 + (double)o1), (double)4.0, (double)6.0, (double)(16.0 + (double)o1), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST_PILLAR = Block.m_49796_((double)(0.0 - (double)o1), (double)4.0, (double)6.0, (double)(12.0 - (double)o1), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH_PILLAR = Block.m_49796_((double)6.0, (double)0.0, (double)(4.0 + (double)o1), (double)10.0, (double)12.0, (double)(16.0 + (double)o1));
    protected static final VoxelShape SHAPE_DOWN_NORTH_PILLAR = Block.m_49796_((double)6.0, (double)0.0, (double)(0.0 - (double)o1), (double)10.0, (double)12.0, (double)(12.0 - (double)o1));
    protected static final VoxelShape SHAPE_DOWN_EAST_PILLAR = Block.m_49796_((double)(4.0 + (double)o1), (double)0.0, (double)6.0, (double)(16.0 + (double)o1), (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST_PILLAR = Block.m_49796_((double)(0.0 - (double)o1), (double)0.0, (double)6.0, (double)(12.0 - (double)o1), (double)12.0, (double)10.0);
    static int o2 = 4;
    protected static final VoxelShape SHAPE_UP_SOUTH_WALL = Block.m_49796_((double)6.0, (double)4.0, (double)(4.0 + (double)o2 - 2.0), (double)10.0, (double)16.0, (double)(16.0 + (double)o2));
    protected static final VoxelShape SHAPE_UP_NORTH_WALL = Block.m_49796_((double)6.0, (double)4.0, (double)(0.0 - (double)o2), (double)10.0, (double)16.0, (double)(12.0 - (double)o2 + 2.0));
    protected static final VoxelShape SHAPE_UP_EAST_WALL = Block.m_49796_((double)(4.0 + (double)o2 - 2.0), (double)4.0, (double)6.0, (double)(16.0 + (double)o2), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST_WALL = Block.m_49796_((double)(0.0 - (double)o2), (double)4.0, (double)6.0, (double)(12.0 - (double)o2 + 2.0), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH_WALL = Block.m_49796_((double)6.0, (double)0.0, (double)(4.0 + (double)o2 - 2.0), (double)10.0, (double)12.0, (double)(16.0 + (double)o2));
    protected static final VoxelShape SHAPE_DOWN_NORTH_WALL = Block.m_49796_((double)6.0, (double)0.0, (double)(0.0 - (double)o2), (double)10.0, (double)12.0, (double)(12.0 - (double)o2 + 2.0));
    protected static final VoxelShape SHAPE_DOWN_EAST_WALL = Block.m_49796_((double)(4.0 + (double)o2 - 2.0), (double)0.0, (double)6.0, (double)(16.0 + (double)o2), (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST_WALL = Block.m_49796_((double)(0.0 - (double)o2), (double)0.0, (double)6.0, (double)(12.0 - (double)o2 + 2.0), (double)12.0, (double)10.0);
    static int o3 = 6;
    protected static final VoxelShape SHAPE_UP_SOUTH_FENCE = Block.m_49796_((double)6.0, (double)4.0, (double)(4.0 + (double)o3 - 4.0), (double)10.0, (double)16.0, (double)(16.0 + (double)o3));
    protected static final VoxelShape SHAPE_UP_NORTH_FENCE = Block.m_49796_((double)6.0, (double)4.0, (double)(0.0 - (double)o3), (double)10.0, (double)16.0, (double)(12.0 - (double)o3 + 4.0));
    protected static final VoxelShape SHAPE_UP_EAST_FENCE = Block.m_49796_((double)(4.0 + (double)o3 - 4.0), (double)4.0, (double)6.0, (double)(16.0 + (double)o3), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST_FENCE = Block.m_49796_((double)(0.0 - (double)o3), (double)4.0, (double)6.0, (double)(12.0 - (double)o3 + 4.0), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH_FENCE = Block.m_49796_((double)6.0, (double)0.0, (double)(4.0 + (double)o3 - 4.0), (double)10.0, (double)12.0, (double)(16.0 + (double)o3));
    protected static final VoxelShape SHAPE_DOWN_NORTH_FENCE = Block.m_49796_((double)6.0, (double)0.0, (double)(0.0 - (double)o3), (double)10.0, (double)12.0, (double)(12.0 - (double)o3 + 4.0));
    protected static final VoxelShape SHAPE_DOWN_EAST_FENCE = Block.m_49796_((double)(4.0 + (double)o3 - 4.0), (double)0.0, (double)6.0, (double)(16.0 + (double)o3), (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST_FENCE = Block.m_49796_((double)(0.0 - (double)o3), (double)0.0, (double)6.0, (double)(12.0 - (double)o3 + 4.0), (double)12.0, (double)10.0);

    public SupportBracket(String name) {
        super("support_bracket_" + name, Blocks.f_50705_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUPPORTING, (Comparable)Direction.UP)).m_61124_(MOUNT, (Comparable)((Object)MountState.FullBlock)));
    }

    public SupportBracket(String name, Block b) {
        super("support_bracket_" + name, b);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUPPORTING, (Comparable)Direction.UP)).m_61124_(MOUNT, (Comparable)((Object)MountState.FullBlock)));
    }

    private VoxelShape getShapeNorth(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_NORTH : SHAPE_DOWN_NORTH;
            }
            case Pillar: {
                return up ? SHAPE_UP_NORTH_PILLAR : SHAPE_DOWN_NORTH_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_NORTH_WALL : SHAPE_DOWN_NORTH_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_NORTH_FENCE : SHAPE_DOWN_NORTH_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    private VoxelShape getShapeSouth(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_SOUTH : SHAPE_DOWN_SOUTH;
            }
            case Pillar: {
                return up ? SHAPE_UP_SOUTH_PILLAR : SHAPE_DOWN_SOUTH_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_SOUTH_WALL : SHAPE_DOWN_SOUTH_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_SOUTH_FENCE : SHAPE_DOWN_SOUTH_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    private VoxelShape getShapeEast(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_EAST : SHAPE_DOWN_EAST;
            }
            case Pillar: {
                return up ? SHAPE_UP_EAST_PILLAR : SHAPE_DOWN_EAST_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_EAST_WALL : SHAPE_DOWN_EAST_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_EAST_FENCE : SHAPE_DOWN_EAST_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    private VoxelShape getShapeWest(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_WEST : SHAPE_DOWN_WEST;
            }
            case Pillar: {
                return up ? SHAPE_UP_WEST_PILLAR : SHAPE_DOWN_WEST_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_WEST_WALL : SHAPE_DOWN_WEST_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_WEST_FENCE : SHAPE_DOWN_WEST_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return this.getShapeNorth((MountState)((Object)state.m_61143_(MOUNT)), state.m_61143_((Property)SUPPORTING) == Direction.UP);
            }
            case EAST: {
                return this.getShapeEast((MountState)((Object)state.m_61143_(MOUNT)), state.m_61143_((Property)SUPPORTING) == Direction.UP);
            }
            case SOUTH: {
                return this.getShapeSouth((MountState)((Object)state.m_61143_(MOUNT)), state.m_61143_((Property)SUPPORTING) == Direction.UP);
            }
            case WEST: {
                return this.getShapeWest((MountState)((Object)state.m_61143_(MOUNT)), state.m_61143_((Property)SUPPORTING) == Direction.UP);
            }
        }
        return SHAPE_UP_NORTH;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SUPPORTING, MOUNT});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        Direction f = c.m_43719_();
        if (f == Direction.UP) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_())).m_61124_((Property)SUPPORTING, (Comparable)Direction.DOWN);
        }
        if (f == Direction.DOWN) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_())).m_61124_((Property)SUPPORTING, (Comparable)Direction.UP);
        }
        double flag = c.m_43720_().f_82480_ - (double)c.m_8083_().m_123342_() - 0.5;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)f.m_122424_())).m_61124_((Property)SUPPORTING, (Comparable)(flag > 0.0 ? Direction.UP : Direction.DOWN))).m_61124_(MOUNT, (Comparable)((Object)MountState.getFor(c.m_43719_(), c.m_8083_(), c.m_43725_())));
    }
}

