/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.tileentity;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.blocks.Bookshelf;
import com.mrh0.buildersaddition.container.BookshelfContainer;
import com.mrh0.buildersaddition.util.IComparetorOverride;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BookshelfTileEntity
extends BlockEntity
implements MenuProvider,
IComparetorOverride {
    public static int SLOTS = 18;
    public final ItemStackHandler handler = new ItemStackHandler(SLOTS){

        protected void onContentsChanged(int slot) {
            BookshelfTileEntity.this.changed(slot);
            BookshelfTileEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public BookshelfTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Index.BOOKSHELF_TILE_ENTITY_TYPE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("ItemStackHandler", (Tag)this.handler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.handler.deserializeNBT(nbt.m_128469_("ItemStackHandler"));
        super.m_142466_(nbt);
    }

    public void changed(int slot) {
        BlockState bs = this.f_58857_.m_8055_(this.m_58899_());
        if (bs.m_60734_() instanceof Bookshelf) {
            this.f_58857_.m_46597_(this.m_58899_(), Bookshelf.getState(bs, this.hasIn(0), this.hasIn(1), this.hasIn(2), this.hasIn(3), this.hasIn(4), this.hasIn(5), this.hasIn(6), this.hasIn(7)));
        }
    }

    private boolean hasIn(int i) {
        if (i == 0) {
            return this.handler.getStackInSlot(0).m_41613_() > 0 || this.handler.getStackInSlot(1).m_41613_() > 0 || this.handler.getStackInSlot(2).m_41613_() > 0;
        }
        if (i == 7) {
            return this.handler.getStackInSlot(15).m_41613_() > 0 || this.handler.getStackInSlot(16).m_41613_() > 0 || this.handler.getStackInSlot(17).m_41613_() > 0;
        }
        return this.handler.getStackInSlot(i * 2 + 1).m_41613_() > 0 || this.handler.getStackInSlot(i * 2 + 2).m_41613_() > 0;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.handler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public int getComparetorOverride() {
        return AbstractContainerMenu.m_38918_((BlockEntity)this);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new BookshelfContainer(id, inv, this, (ContainerData)new SimpleContainerData(0));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.buildersaddition.bookshelf");
    }
}

