/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.corelib.client.RenderUtils;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererSplitTank
implements BlockEntityRenderer<TileEntitySplitTank> {
    private static final FluidStack BIO_DIESEL_STACK = new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), 1);
    private static final FluidStack GLYCERIN_STACK = new FluidStack((Fluid)ModFluids.GLYCERIN.get(), 1);
    protected BlockEntityRendererProvider.Context renderer;

    public TileEntitySpecialRendererSplitTank(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public void render(TileEntitySplitTank te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.m_85836_();
        float bioDiesel = te.getBioDieselPerc() / 2.0f;
        float glycerin = te.getGlycerinPerc() / 2.0f;
        if (bioDiesel > 0.0f) {
            this.renderFluid(BIO_DIESEL_STACK, bioDiesel, 0.0625f, matrixStack, buffer, light, overlay);
        }
        if (glycerin > 0.0f) {
            this.renderFluid(GLYCERIN_STACK, glycerin, bioDiesel + 0.0625f, matrixStack, buffer, light, overlay);
        }
        matrixStack.m_85849_();
    }

    public void renderFluid(FluidStack fluid, float amount, float yStart, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.98f, 0.98f, 0.98f);
        matrixStack.m_252880_(0.01f, 0.01f, 0.01f);
        VertexConsumer builder = buffer.m_6299_(Sheets.m_110791_());
        IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(type.getStillTexture(fluid));
        float uMin = texture.m_118409_();
        float uMax = texture.m_118410_();
        float vMin = texture.m_118411_();
        float vMax = texture.m_118412_();
        float vHeight = vMax - vMin;
        float s = 0.0f;
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, light, overlay);
        matrixStack.m_85849_();
    }
}

