/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.gui.CarOptionsSoundsScreen;
import de.maxhenkel.car.sounds.ModSounds;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SoundOptionsScreen;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SoundEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onOpenGUI(ScreenEvent.Opening event) {
        if (!(event.getScreen() instanceof SoundOptionsScreen)) {
            return;
        }
        SoundOptionsScreen sounds = (SoundOptionsScreen)event.getScreen();
        if (!sounds.getClass().equals(SoundOptionsScreen.class)) {
            return;
        }
        try {
            Field parentField = null;
            for (Field field : sounds.getClass().getSuperclass().getDeclaredFields()) {
                if (!field.getType().equals(Screen.class)) continue;
                parentField = field;
                break;
            }
            if (parentField == null) {
                return;
            }
            parentField.setAccessible(true);
            Screen parent = (Screen)parentField.get(sounds);
            event.setNewScreen((Screen)new CarOptionsSoundsScreen(parent, Minecraft.m_91087_().f_91066_));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onSound(PlayLevelSoundEvent.AtEntity event) {
        if (event.getSound() != null && ModSounds.isCarSoundCategory((SoundEvent)event.getSound().get())) {
            event.setNewVolume(((Double)Main.CLIENT_CONFIG.carVolume.get()).floatValue());
        }
    }

    @SubscribeEvent
    public void onSound(PlayLevelSoundEvent.AtPosition event) {
        if (event.getSound() != null && ModSounds.isCarSoundCategory((SoundEvent)event.getSound().get())) {
            event.setNewVolume(((Double)Main.CLIENT_CONFIG.carVolume.get()).floatValue());
        }
    }
}

