/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;

public class GuiBackmixReactor
extends ScreenBase<ContainerBackmixReactor> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_backmix_reactor.png");
    private Container playerInv;
    private TileEntityBackmixReactor tile;

    public GuiBackmixReactor(ContainerBackmixReactor container, Inventory playerInv, Component name) {
        super(GUI_TEXTURE, container, playerInv, name);
        this.playerInv = playerInv;
        this.tile = container.getBackmixReactor();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.f_169604_.m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (mouseX >= this.f_97735_ + 11 && mouseX <= this.f_97735_ + 16 + 11 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.energy", (Object[])new Object[]{this.tile.getStoredEnergy()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 33 && mouseX <= this.f_97735_ + 16 + 33 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.oil", (Object[])new Object[]{this.tile.getCurrentCanola()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 55 && mouseX <= this.f_97735_ + 16 + 55 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.methanol", (Object[])new Object[]{this.tile.getCurrentMethanol()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 122 && mouseX <= this.f_97735_ + 16 + 122 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.mix", (Object[])new Object[]{this.tile.getCurrentMix()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 79 && mouseX <= this.f_97735_ + 24 + 79 && mouseY >= this.f_97736_ + 34 && mouseY <= this.f_97736_ + 17 + 34) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.progress", (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawProgress(guiGraphics);
        this.drawEnergy(guiGraphics);
        this.drawCanola(guiGraphics);
        this.drawMethanol(guiGraphics);
        this.drawMix(guiGraphics);
    }

    public void drawEnergy(GuiGraphics guiGraphics) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(GUI_TEXTURE, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawCanola(GuiGraphics guiGraphics) {
        float perc = this.getCanola();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 33;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(GUI_TEXTURE, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMethanol(GuiGraphics guiGraphics) {
        float perc = this.getMethanol();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 55;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(GUI_TEXTURE, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMix(GuiGraphics guiGraphics) {
        float perc = this.getMix();
        int texX = 224;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(GUI_TEXTURE, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress(GuiGraphics guiGraphics) {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(GUI_TEXTURE, i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getCanola() {
        return (float)this.tile.getCurrentCanola() / (float)this.tile.maxCanola;
    }

    public float getMethanol() {
        return (float)this.tile.getCurrentMethanol() / (float)this.tile.maxMethanol;
    }

    public float getMix() {
        return (float)this.tile.getCurrentMix() / (float)this.tile.maxMix;
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.getTimeToGenerate();
        return (float)time / (float)this.tile.generatingTime;
    }
}

