/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityEnergyFluidProducer;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerEnergyFluidProducer;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public abstract class GuiEnergyFluidProducer<T extends ContainerEnergyFluidProducer>
extends ScreenBase<T> {
    private Inventory playerInv;
    private TileEntityEnergyFluidProducer tile;

    public GuiEnergyFluidProducer(ResourceLocation texture, T container, Inventory playerInventory, Component title) {
        super(texture, container, playerInventory, title);
        this.playerInv = playerInventory;
        this.tile = ((ContainerEnergyFluidProducer)((Object)container)).getTile();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    public String getUnlocalizedTooltipEnergy() {
        return "tooltip.energy";
    }

    public String getUnlocalizedTooltipProgress() {
        return "tooltip.progress";
    }

    public abstract String getUnlocalizedTooltipLiquid();

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.m_96636_().m_7532_(), 38, 6, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (mouseX >= this.f_97735_ + 11 && mouseX <= this.f_97735_ + 16 + 11 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)this.getUnlocalizedTooltipEnergy(), (Object[])new Object[]{this.tile.getStoredEnergy()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 148 && mouseX <= this.f_97735_ + 16 + 148 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)this.getUnlocalizedTooltipLiquid(), (Object[])new Object[]{this.tile.getCurrentMillibuckets()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 79 && mouseX <= this.f_97735_ + 24 + 79 && mouseY >= this.f_97736_ + 34 && mouseY <= this.f_97736_ + 17 + 34) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)this.getUnlocalizedTooltipProgress(), (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public void drawEnergy(GuiGraphics guiGraphics) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid(GuiGraphics guiGraphics) {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 148;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress(GuiGraphics guiGraphics) {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.getMaxEnergy();
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.getFluidAmount();
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        return (float)this.tile.getGeneratingTime() / (float)this.tile.getTimeToGenerate();
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawEnergy(guiGraphics);
        this.drawFluid(guiGraphics);
        this.drawProgress(guiGraphics);
    }

    public boolean m_7043_() {
        return false;
    }
}

