/*
 * Decompiled with CFR 0.152.
 */
package com.xx1th.chromatocreeper.common;

import com.xx1th.chromatocreeper.common.config.Config;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTexture {
    public final BlockState blockState;
    public final Color intensity;

    public BlockTexture(BlockState blockState, Color intensity) {
        this.blockState = blockState;
        this.intensity = intensity;
    }

    public String hash() {
        return this.blockState.m_60734_().getRegistryName() + this.intensity.toString();
    }

    public static BlockTexture pick(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos, BlockState blockState) {
        Color intensity = BlockTexture.getIntensity(blockAndTintGetter, blockPos, blockState);
        blockState = Optional.ofNullable(Config.replaceBlockState(blockState)).orElse(blockState);
        return new BlockTexture(blockState, intensity);
    }

    public static Color getIntensity(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos, BlockState blockState) {
        return new Color(Minecraft.m_91087_().m_91298_().m_92577_(blockState, blockAndTintGetter, blockPos, 0));
    }
}

