/*
 * Decompiled with CFR 0.152.
 */
package com.xx1th.chromatocreeper.common;

import com.mojang.blaze3d.platform.NativeImage;
import com.xx1th.chromatocreeper.common.config.Config;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class ChromatoCreator {
    private static final ResourceLocation CREEPER_MAP_TEXTURE = new ResourceLocation("chromatocreeper", "textures/creeper_map.png");
    private static final ResourceLocation CREEPER_OVERLAY_TEXTURE = new ResourceLocation("chromatocreeper", "textures/creeper_overlay.png");
    private static final int CREEPER_WIDTH = 64;
    private static final int CREEPER_HEIGHT = 32;
    private static final int BLOCK_WIDTH = 16;

    private static ResourceLocation pickTexture(BlockState blockState) {
        ResourceLocation resourceLocation = Optional.ofNullable(Config.replaceTexturePath(blockState)).orElseGet(() -> Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(blockState).m_118413_());
        return new ResourceLocation(resourceLocation.m_135827_(), "textures/" + resourceLocation.m_135815_() + ".png");
    }

    private static InputStream getResource(ResourceLocation resourceLocation) throws IOException {
        return Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation).m_6679_();
    }

    @Nullable
    public static ResourceLocation generateTexture(BlockState blockState, Color intensity) {
        BufferedImage mapImage;
        BufferedImage overlayImage;
        BufferedImage blockImage;
        ResourceLocation blockTexturePath = ChromatoCreator.pickTexture(blockState);
        try {
            blockImage = ImageIO.read(ChromatoCreator.getResource(blockTexturePath));
            overlayImage = ImageIO.read(ChromatoCreator.getResource(CREEPER_OVERLAY_TEXTURE));
            mapImage = ImageIO.read(ChromatoCreator.getResource(CREEPER_MAP_TEXTURE));
        }
        catch (IOException ioException) {
            return null;
        }
        NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, 64, 32, false);
        nativeImage.m_84997_(0, 0, 64, 32, new Color(0, 0, 0, 0).getRGB());
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 32; ++y) {
                Color blockPixelColor = new Color(blockImage.getRGB(x % 16, y % 16), true);
                Color overlayPixelColor = new Color(overlayImage.getRGB(x, y), true);
                if (mapImage.getRGB(x, y) != Color.black.getRGB()) continue;
                Color result = ChromatoCreator.mixColors(blockPixelColor, overlayPixelColor, intensity);
                nativeImage.m_84988_(x, y, result.getRGB());
            }
        }
        return Minecraft.m_91087_().m_91097_().m_118490_("chromatocreeper", new DynamicTexture(nativeImage));
    }

    private static Color mixColors(Color base, Color overlay, Color intensity) {
        float ratio = (float)overlay.getAlpha() / 255.0f;
        int r = (int)(((float)base.getRed() * (1.0f - ratio) + (float)overlay.getRed() * ratio) * (float)intensity.getRed() / 255.0f);
        int g = (int)(((float)base.getGreen() * (1.0f - ratio) + (float)overlay.getGreen() * ratio) * (float)intensity.getGreen() / 255.0f);
        int b = (int)(((float)base.getBlue() * (1.0f - ratio) + (float)overlay.getBlue() * ratio) * (float)intensity.getBlue() / 255.0f);
        int a = base.getAlpha();
        return new Color(b, g, r, a);
    }
}

