/*
 * Decompiled with CFR 0.152.
 */
package com.xx1th.chromatocreeper.common;

import com.xx1th.chromatocreeper.common.BlockTexture;
import com.xx1th.chromatocreeper.common.ChromatoCache;
import com.xx1th.chromatocreeper.common.ChromatoCreator;
import com.xx1th.chromatocreeper.common.ILastTextureCacher;
import com.xx1th.chromatocreeper.common.config.Config;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class ChromatoManager {
    @Nullable
    private static SelectBlock scanBlock(Creeper creeper) {
        ArrayList<BlockPos> scanList = new ArrayList<BlockPos>();
        BlockPos position = creeper.m_142538_();
        scanList.add(position);
        scanList.add(position.m_7495_());
        scanList.add(position.m_7494_());
        SelectBlock selectBlock = null;
        Level blockAndTintGetter = creeper.f_19853_;
        for (BlockPos blockPos : scanList) {
            BlockState blockState = blockAndTintGetter.m_8055_(blockPos);
            FluidState fluidState = blockAndTintGetter.m_6425_(blockPos);
            if (!fluidState.m_76178_()) {
                blockState = fluidState.m_76188_();
            }
            if (Config.isIgnoreBlock(blockState)) continue;
            selectBlock = new SelectBlock(blockPos, blockState);
            break;
        }
        return selectBlock;
    }

    public static ResourceLocation getTexture(Creeper creeper, ResourceLocation defaultTexture) {
        Level blockAndTintGetter = creeper.f_19853_;
        return Optional.ofNullable(ChromatoManager.scanBlock(creeper)).map(arg_0 -> ChromatoManager.lambda$getTexture$1((BlockAndTintGetter)blockAndTintGetter, defaultTexture, creeper, arg_0)).orElseGet(() -> Optional.ofNullable(((ILastTextureCacher)creeper).getLastTexture()).orElse(defaultTexture));
    }

    private static /* synthetic */ ResourceLocation lambda$getTexture$1(BlockAndTintGetter blockAndTintGetter, ResourceLocation defaultTexture, Creeper creeper, SelectBlock selectBlock) {
        BlockTexture blockTexture = BlockTexture.pick(blockAndTintGetter, selectBlock.blockPos, selectBlock.blockState);
        ResourceLocation texture = Optional.ofNullable(ChromatoCache.get(blockTexture.hash())).orElseGet(() -> {
            ResourceLocation resourceLocation = Optional.ofNullable(ChromatoCreator.generateTexture(blockTexture.blockState, blockTexture.intensity)).orElse(defaultTexture);
            ChromatoCache.put(blockTexture.hash(), resourceLocation);
            return resourceLocation;
        });
        ((ILastTextureCacher)creeper).putLastTexture(texture);
        return texture;
    }

    private static class SelectBlock {
        public BlockPos blockPos;
        public BlockState blockState;

        public SelectBlock(BlockPos blockPos, BlockState blockState) {
            this.blockPos = blockPos;
            this.blockState = blockState;
        }
    }
}

