/*
 * Decompiled with CFR 0.152.
 */
package com.xx1th.chromatocreeper.common.config;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.xx1th.chromatocreeper.common.config.ConfigSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class Config {
    public static ArrayList<Class<?>> ignoreBlockClasses = new ArrayList();
    public static HashSet<Material> ignoreMaterials = new HashSet();
    public static HashSet<String> ignoreResourceLocations = new HashSet();
    public static HashMap<String, BlockState> replaceBlockStates = new HashMap();
    public static HashMap<String, ResourceLocation> replaceTexturePaths = new HashMap();

    public static void load() {
        String fromRegistryName2;
        for (String classType : (List)ConfigSpec.configVals.ignoreBlockClasses.get()) {
            try {
                ignoreBlockClasses.add(Class.forName(classType));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        for (String material : (List)ConfigSpec.configVals.ignoreMaterials.get()) {
            try {
                ignoreMaterials.add(new BlockStateArgument().parse(new StringReader(material)).m_114669_().m_60767_());
            }
            catch (CommandSyntaxException commandSyntaxException) {}
        }
        ignoreResourceLocations.addAll((Collection)ConfigSpec.configVals.ignoreResourceLocations.get());
        for (List map : (List)ConfigSpec.configVals.replaceBlockStates.get()) {
            try {
                fromRegistryName2 = (String)map.get(0);
                BlockState toBlockState = new BlockStateArgument().parse(new StringReader((String)map.get(1))).m_114669_();
                replaceBlockStates.put(fromRegistryName2, toBlockState);
            }
            catch (CommandSyntaxException fromRegistryName2) {}
        }
        for (List map : (List)ConfigSpec.configVals.replaceTexturePaths.get()) {
            fromRegistryName2 = (String)map.get(0);
            ResourceLocation toTexturePath = new ResourceLocation((String)map.get(1));
            replaceTexturePaths.put(fromRegistryName2, toTexturePath);
        }
    }

    public static boolean isIgnoreBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (replaceBlockStates.containsKey(block.getRegistryName().toString()) || replaceTexturePaths.containsKey(block.getRegistryName().toString())) {
            return false;
        }
        if (ignoreMaterials.contains(blockState.m_60767_())) {
            return true;
        }
        if (ignoreResourceLocations.contains(block.getRegistryName().toString())) {
            return true;
        }
        for (Class<?> classType : ignoreBlockClasses) {
            if (!classType.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static BlockState replaceBlockState(BlockState blockState) {
        return replaceBlockStates.get(blockState.m_60734_().getRegistryName().toString());
    }

    @Nullable
    public static ResourceLocation replaceTexturePath(BlockState blockState) {
        return replaceTexturePaths.get(blockState.m_60734_().getRegistryName().toString());
    }
}

