/*
 * Decompiled with CFR 0.152.
 */
package com.xx1th.chromatocreeper.common.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigSpec {
    public static final ForgeConfigSpec configSpec;
    public static final ConfigVals configVals;

    static {
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ConfigVals::new);
        configSpec = (ForgeConfigSpec)specPair2.getRight();
        configVals = (ConfigVals)specPair2.getLeft();
    }

    public static class ConfigVals {
        public ForgeConfigSpec.ConfigValue<List<String>> ignoreBlockClasses;
        public ForgeConfigSpec.ConfigValue<List<String>> ignoreMaterials;
        public ForgeConfigSpec.ConfigValue<List<String>> ignoreResourceLocations;
        public ForgeConfigSpec.ConfigValue<List<List<String>>> replaceBlockStates;
        public ForgeConfigSpec.ConfigValue<List<List<String>>> replaceTexturePaths;

        public ConfigVals(ForgeConfigSpec.Builder builder) {
            builder.comment(" Ignore List").push("Ignore");
            this.ignoreBlockClasses = builder.comment(" Whether the block is one of the instance of the class in following list.").define("Ignore Class", new ArrayList<String>(Arrays.asList("net.minecraft.world.level.block.BaseEntityBlock", "net.minecraft.world.level.block.HorizontalDirectionalBlock", "net.minecraft.world.level.block.BaseCoralPlantTypeBlock", "net.minecraft.world.level.block.AbstractBannerBlock", "net.minecraft.world.level.block.DoorBlock")));
            this.ignoreMaterials = builder.comment(" Mod will get a \"Material list\" according to following list.\n Then, check whether the block's material is in \"Material list\".\n WARN: you shouldn't remove \"minecraft:air\" from the list.\n     i.e. \"minecraft:air\"            -> Material.AIR\n          \"minecraft:powered_rail\"   -> Material.DECORATION\n          /* #Plants Start */\n          \"minecraft:oak_leaves\"     -> Material.LEAVES\n          \"minecraft:oak_sapling\"    -> Material.PLANT\n          \"minecraft:kelp\"           -> Material.WATER_PLANT\n          \"minecraft:grass\"          -> Material.REPLACEABLE_PLANT\n          \"minecraft:warped_roots\"   -> Material.REPLACEABLE_FIREPROOF_PLANT\n          \"minecraft:seagrass\"       -> Material.REPLACEABLE_WATER_PLANT\n          \"minecraft:pumpkin\"        -> Material.VEGETABLE\n          \"minecraft:cactus\"         -> Material.CACTUS\n          /* #Plants End */\n          \"minecraft:fire\"           -> Material.FIRE\n          \"minecraft:glass\"          -> Material.GLASS\n          \"minecraft:nether_portal\"  -> Material.PORTAL\n          \"minecraft:anvil\"          -> Material.HEAVY_METAL\n          \"minecraft:sponge\"         -> Material.SPONGE\n          \"minecraft:tnt\"            -> Material.EXPLOSIVE").define("Ignore Material", new ArrayList<String>(Arrays.asList("minecraft:air", "minecraft:powered_rail", "minecraft:oak_leaves", "minecraft:oak_sapling", "minecraft:kelp", "minecraft:grass", "minecraft:warped_roots", "minecraft:seagrass", "minecraft:pumpkin", "minecraft:cactus", "minecraft:fire", "minecraft:glass", "minecraft:nether_portal", "minecraft:anvil", "minecraft:sponge", "minecraft:tnt")));
            this.ignoreResourceLocations = builder.comment(" Whether the block is in following list.").define("Ignore ResourceLocation", new ArrayList<String>(Arrays.asList("minecraft:chain", "minecraft:barrier", "minecraft:iron_bars", "minecraft:bamboo_sapling", "minecraft:lantern", "minecraft:soul_lantern", "minecraft:cauldron", "minecraft:cake", "minecraft:stonecutter", "minecraft:jigsaw", "minecraft:composter", "minecraft:smithing_table", "minecraft:fletching_table", "minecraft:cartography_table", "minecraft:crafting_table", "minecraft:cobweb", "minecraft:redstone_lamp", "minecraft:spawner", "minecraft:pointed_dripstone", "minecraft:small_amethyst_bud", "minecraft:medium_amethyst_bud", "minecraft:large_amethyst_bud", "minecraft:amethyst_cluster")));
            builder.pop();
            builder.comment(" Replace List").push("Replace");
            this.replaceBlockStates = builder.comment(" Give a mapping list to override.").define("Replace BlockState", new ArrayList<List>(Arrays.asList(Arrays.asList("minecraft:furnace", "minecraft:cobblestone"), Arrays.asList("minecraft:dispenser", "minecraft:cobblestone"), Arrays.asList("minecraft:piston", "minecraft:cobblestone"), Arrays.asList("minecraft:sticky_piston", "minecraft:cobblestone"), Arrays.asList("minecraft:piston_head", "minecraft:oak_planks"), Arrays.asList("minecraft:dropper", "minecraft:cobblestone"), Arrays.asList("minecraft:observer", "minecraft:cobblestone"), Arrays.asList("minecraft:gold_ore", "minecraft:stone"), Arrays.asList("minecraft:iron_ore", "minecraft:stone"), Arrays.asList("minecraft:coal_ore", "minecraft:stone"), Arrays.asList("minecraft:lapis_ore", "minecraft:stone"), Arrays.asList("minecraft:diamond_ore", "minecraft:stone"), Arrays.asList("minecraft:redstone_ore", "minecraft:stone"), Arrays.asList("minecraft:emerald_ore", "minecraft:stone"), Arrays.asList("minecraft:copper_ore", "minecraft:stone"), Arrays.asList("minecraft:deepslate_gold_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_iron_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_coal_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_lapis_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_diamond_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_redstone_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_emerald_ore", "minecraft:deepslate"), Arrays.asList("minecraft:deepslate_copper_ore", "minecraft:deepslate"), Arrays.asList("minecraft:nether_gold_ore", "minecraft:netherrack"), Arrays.asList("minecraft:nether_quartz_ore", "minecraft:netherrack"), Arrays.asList("minecraft:lectern", "minecraft:oak_planks"), Arrays.asList("minecraft:bookshelf", "minecraft:oak_planks"), Arrays.asList("minecraft:end_portal_frame", "minecraft:end_stone"), Arrays.asList("minecraft:enchanting_table", "minecraft:obsidian"), Arrays.asList("minecraft:respawn_anchor", "minecraft:crying_obsidian"))));
            this.replaceTexturePaths = builder.comment(" This mod picks block's texture from BlockModelShapes in runtime,\n and usually choose the side of block. Sometimes, it's not what we want.\n So, the following list will replace the pattern in actual got TexturePath.\n     i.e. [\"minecraft:crimson_nylium\", \"minecraft:block/crimson_nylium\"] means:\n          for \"Block{minecraft:crimson_nylium}\"\n          get \"block/crimson_nylium_side.png\" in \"minecraft/\" from BlockModelShapes\n          change it to block/crimson_nylium.png in \"minecraft/\"").define("Replace TexturePath", new ArrayList<List>(Arrays.asList(Arrays.asList("minecraft:crimson_nylium", "minecraft:block/crimson_nylium"), Arrays.asList("minecraft:warped_nylium", "minecraft:block/warped_nylium"), Arrays.asList("minecraft:grass_block", "minecraft:block/grass_block_top"), Arrays.asList("minecraft:dirt_path", "minecraft:block/dirt_path_top"), Arrays.asList("minecraft:podzol", "minecraft:block/podzol_top"), Arrays.asList("minecraft:mycelium", "minecraft:block/mycelium_top"))));
            builder.pop();
        }
    }
}

