/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.client;

import com.illusivesoulworks.comforts.common.block.HammockBlock;
import com.illusivesoulworks.comforts.common.block.SleepingBagBlock;
import com.illusivesoulworks.comforts.platform.Services;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ComfortsClientEvents {
    public static void onPlayerRenderPre(Player player, PoseStack poseStack) {
        if (player.m_20089_() == Pose.SLEEPING) {
            if (player instanceof RemotePlayer) {
                player.m_21257_().ifPresent(bedPos -> {
                    Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                    if (bed instanceof SleepingBagBlock) {
                        poseStack.m_85837_(0.0, -0.375, 0.0);
                    } else if (bed instanceof HammockBlock) {
                        poseStack.m_85837_(0.0, -0.5, 0.0);
                    }
                });
            } else if (player instanceof LocalPlayer) {
                player.m_21257_().ifPresent(bedPos -> {
                    Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                    if (bed instanceof SleepingBagBlock) {
                        player.f_20921_ = 0.0f;
                        player.f_20920_ = 0.0f;
                    }
                });
            }
        }
    }

    public static void onPlayerRenderPost(Player player, PoseStack poseStack) {
        if (player instanceof RemotePlayer && player.m_20089_() == Pose.SLEEPING) {
            player.m_21257_().ifPresent(bedPos -> {
                Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                if (bed instanceof SleepingBagBlock) {
                    poseStack.m_85837_(0.0, 0.375, 0.0);
                } else if (bed instanceof HammockBlock) {
                    poseStack.m_85837_(0.0, 0.5, 0.0);
                }
            });
        }
    }

    public static void onTick(Player player) {
        if (!player.m_5803_()) {
            Services.SLEEP_EVENTS.getSleepData(player).ifPresent(data -> {
                BlockPos pos = data.getAutoSleepPos();
                if (pos != null) {
                    Level level = player.f_19853_;
                    BlockState state = level.m_8055_(pos);
                    if (level.m_46749_(pos) && state.m_60734_() instanceof SleepingBagBlock) {
                        BlockHitResult hit = new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Direction.UP, pos, false);
                        MultiPlayerGameMode playerController = Minecraft.m_91087_().f_91072_;
                        if (playerController != null) {
                            playerController.m_233732_((LocalPlayer)player, InteractionHand.MAIN_HAND, hit);
                        }
                    }
                    data.setAutoSleepPos(null);
                }
            });
        }
    }
}

