/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts;

import com.illusivesoulworks.comforts.ComfortsCommonMod;
import com.illusivesoulworks.comforts.ComfortsForgeClientMod;
import com.illusivesoulworks.comforts.common.CapabilitySleepData;
import com.illusivesoulworks.comforts.common.ComfortsCommonEventsListener;
import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.common.capability.ISleepData;
import com.illusivesoulworks.comforts.common.network.ComfortsForgeNetwork;
import com.illusivesoulworks.comforts.common.registry.RegistryObject;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="comforts")
public class ComfortsForgeMod {
    public ComfortsForgeMod() {
        ComfortsCommonMod.init();
        ComfortsCommonMod.initConfig();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ComfortsForgeClientMod::init);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::creativeTab);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ComfortsCommonEventsListener());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilitySleepData.CapabilityEvents());
        ComfortsForgeNetwork.setup();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(ISleepData.class);
    }

    private void creativeTab(CreativeModeTabEvent.BuildContents evt) {
        CreativeModeTab tab = evt.getTab();
        if (tab == CreativeModeTabs.f_256725_ || tab == CreativeModeTabs.f_256791_) {
            for (RegistryObject<Block> value : ComfortsRegistry.SLEEPING_BAGS.values()) {
                evt.accept(value);
            }
            for (RegistryObject<Block> value : ComfortsRegistry.HAMMOCKS.values()) {
                evt.accept(value);
            }
        }
        if (tab == CreativeModeTabs.f_256791_) {
            evt.accept(ComfortsRegistry.ROPE_AND_NAIL_ITEM);
        }
    }
}

