/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.common.block.HammockBlock;
import com.illusivesoulworks.comforts.common.block.RopeAndNailBlock;
import com.illusivesoulworks.comforts.common.block.SleepingBagBlock;
import com.illusivesoulworks.comforts.common.block.entity.HammockBlockEntity;
import com.illusivesoulworks.comforts.common.block.entity.SleepingBagBlockEntity;
import com.illusivesoulworks.comforts.common.item.BaseComfortsItem;
import com.illusivesoulworks.comforts.common.item.HammockItem;
import com.illusivesoulworks.comforts.common.item.SleepingBagItem;
import com.illusivesoulworks.comforts.common.registry.RegistryObject;
import com.illusivesoulworks.comforts.common.registry.RegistryProvider;
import com.illusivesoulworks.comforts.platform.Services;
import java.util.Arrays;
import java.util.EnumMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ComfortsRegistry {
    public static final RegistryProvider<Block> BLOCKS = RegistryProvider.get(Registries.f_256747_, "comforts");
    public static final RegistryProvider<Item> ITEMS = RegistryProvider.get(Registries.f_256913_, "comforts");
    public static final RegistryProvider<BlockEntityType<?>> BLOCK_ENTITY_TYPES = RegistryProvider.get(Registries.f_256922_, "comforts");
    public static final EnumMap<DyeColor, RegistryObject<Block>> SLEEPING_BAGS = new EnumMap(DyeColor.class);
    public static final EnumMap<DyeColor, RegistryObject<Block>> HAMMOCKS = new EnumMap(DyeColor.class);
    public static final RegistryObject<Block> ROPE_AND_NAIL_BLOCK = BLOCKS.register("rope_and_nail", RopeAndNailBlock::new);
    public static final RegistryObject<Item> ROPE_AND_NAIL_ITEM = ITEMS.register("rope_and_nail", () -> new BaseComfortsItem(ROPE_AND_NAIL_BLOCK.get()));
    public static final RegistryObject<BlockEntityType<SleepingBagBlockEntity>> SLEEPING_BAG_BLOCK_ENTITY;
    public static final RegistryObject<BlockEntityType<HammockBlockEntity>> HAMMOCK_BLOCK_ENTITY;

    public static void init() {
    }

    static {
        Arrays.stream(DyeColor.values()).forEach(color -> {
            SLEEPING_BAGS.put((DyeColor)color, BLOCKS.register("sleeping_bag_" + color.m_41065_(), () -> new SleepingBagBlock((DyeColor)color)));
            HAMMOCKS.put((DyeColor)color, BLOCKS.register("hammock_" + color.m_41065_(), () -> new HammockBlock((DyeColor)color)));
        });
        SLEEPING_BAGS.values().forEach(reg -> ITEMS.register(reg.getId().m_135815_(), () -> new SleepingBagItem((Block)reg.get())));
        HAMMOCKS.values().forEach(reg -> ITEMS.register(reg.getId().m_135815_(), () -> new HammockItem((Block)reg.get())));
        HAMMOCK_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("hammock", () -> Services.REGISTRY_UTIL.createBlockEntityType(HammockBlockEntity::new, (Block[])HAMMOCKS.values().stream().map(RegistryObject::get).toArray(Block[]::new)));
        SLEEPING_BAG_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("sleeping_bag", () -> Services.REGISTRY_UTIL.createBlockEntityType(SleepingBagBlockEntity::new, (Block[])SLEEPING_BAGS.values().stream().map(RegistryObject::get).toArray(Block[]::new)));
    }
}

