/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.common.capability.ISleepData;
import com.illusivesoulworks.comforts.common.capability.SleepDataImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilitySleepData {
    public static final Capability<ISleepData> SLEEP_DATA_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISleepData>(){});
    private static final Map<UUID, LazyOptional<ISleepData>> SERVER_CACHE = new HashMap<UUID, LazyOptional<ISleepData>>();
    private static final Map<UUID, LazyOptional<ISleepData>> CLIENT_CACHE = new HashMap<UUID, LazyOptional<ISleepData>>();

    public static LazyOptional<ISleepData> getCapability(Player player) {
        UUID key = player.getUUID();
        Map<UUID, LazyOptional<ISleepData>> cache = player.level().isClientSide() ? CLIENT_CACHE : SERVER_CACHE;
        return cache.computeIfAbsent(key, k -> {
            LazyOptional opt = player.getCapability(SLEEP_DATA_CAP);
            opt.addListener(v -> cache.remove(key));
            return opt;
        });
    }

    public static class CapabilityEvents {
        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (entity instanceof Player) {
                evt.addCapability(ISleepData.ID, (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone evt) {
            if (evt.isWasDeath()) {
                Player player = evt.getEntity();
                Player original = evt.getOriginal();
                original.reviveCaps();
                CapabilitySleepData.getCapability(player).ifPresent(data -> CapabilitySleepData.getCapability(original).ifPresent(data::copyFrom));
                original.invalidateCaps();
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ISleepData> optional;
        final ISleepData data = new SleepDataImpl();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return SLEEP_DATA_CAP.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT(HolderLookup.Provider provider) {
            return this.data.write();
        }

        public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
            this.data.read((CompoundTag)nbt);
        }
    }
}

