/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.networking.TileEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StationEditPacket
extends TileEntityConfigurationPacket<StationTileEntity> {
    boolean dropSchedule;
    boolean assemblyMode;
    Boolean tryAssemble;
    String name;

    public static StationEditPacket dropSchedule(BlockPos pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.dropSchedule = true;
        return packet;
    }

    public static StationEditPacket tryAssemble(BlockPos pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = true;
        return packet;
    }

    public static StationEditPacket tryDisassemble(BlockPos pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = false;
        return packet;
    }

    public static StationEditPacket configure(BlockPos pos, boolean assemble, String name) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.assemblyMode = assemble;
        packet.tryAssemble = null;
        packet.name = name;
        return packet;
    }

    public StationEditPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public StationEditPacket(BlockPos pos) {
        super(pos);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.dropSchedule);
        if (this.dropSchedule) {
            return;
        }
        buffer.writeBoolean(this.tryAssemble != null);
        if (this.tryAssemble != null) {
            buffer.writeBoolean(this.tryAssemble.booleanValue());
            return;
        }
        buffer.writeBoolean(this.assemblyMode);
        buffer.m_130070_(this.name);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.dropSchedule = true;
            return;
        }
        this.name = "";
        if (buffer.readBoolean()) {
            this.tryAssemble = buffer.readBoolean();
            return;
        }
        this.assemblyMode = buffer.readBoolean();
        this.name = buffer.m_130136_(256);
    }

    @Override
    protected void applySettings(ServerPlayer player, StationTileEntity te) {
        Level level = te.m_58904_();
        BlockPos blockPos = te.m_58899_();
        BlockState blockState = level.m_8055_(blockPos);
        if (this.dropSchedule) {
            this.scheduleDropRequested(player, te);
            return;
        }
        if (!this.name.isBlank()) {
            GlobalStation station = te.getStation();
            GraphLocation graphLocation = te.edgePoint.determineGraphLocation();
            if (station != null && graphLocation != null) {
                station.name = this.name;
                Create.RAILWAYS.sync.pointAdded(graphLocation.graph, station);
                Create.RAILWAYS.markTracksDirty();
            }
        }
        if (!(blockState.m_60734_() instanceof StationBlock)) {
            return;
        }
        Boolean isAssemblyMode = (Boolean)blockState.m_61143_((Property)StationBlock.ASSEMBLING);
        boolean assemblyComplete = false;
        if (this.tryAssemble != null) {
            if (!isAssemblyMode.booleanValue()) {
                return;
            }
            if (this.tryAssemble.booleanValue()) {
                te.assemble(player.m_20148_());
                assemblyComplete = te.getStation() != null && te.getStation().getPresentTrain() != null;
            } else if (this.disassembleAndEnterMode(player, te)) {
                te.refreshAssemblyInfo();
            }
            if (!assemblyComplete) {
                return;
            }
        }
        if (isAssemblyMode == this.assemblyMode) {
            return;
        }
        BlockState newState = (BlockState)blockState.m_61122_((Property)StationBlock.ASSEMBLING);
        Boolean nowAssembling = (Boolean)newState.m_61143_((Property)StationBlock.ASSEMBLING);
        if (nowAssembling.booleanValue()) {
            if (!this.disassembleAndEnterMode(player, te)) {
                return;
            }
        } else {
            te.cancelAssembly();
        }
        level.m_7731_(blockPos, newState, 3);
        te.refreshBlockState();
        if (nowAssembling.booleanValue()) {
            te.refreshAssemblyInfo();
        }
        GlobalStation station = te.getStation();
        GraphLocation graphLocation = te.edgePoint.determineGraphLocation();
        if (station != null && graphLocation != null) {
            station.assembling = nowAssembling;
            Create.RAILWAYS.sync.pointAdded(graphLocation.graph, station);
            Create.RAILWAYS.markTracksDirty();
            if (nowAssembling.booleanValue()) {
                for (Train train : Create.RAILWAYS.sided((LevelAccessor)level).trains.values()) {
                    if (train.navigation.destination != station) continue;
                    GlobalStation preferredDestination = train.runtime.startCurrentInstruction();
                    if (preferredDestination != null) {
                        train.navigation.startNavigation(preferredDestination, Double.MAX_VALUE, false);
                        continue;
                    }
                    train.navigation.startNavigation(station, Double.MAX_VALUE, false);
                }
            }
        }
    }

    private void scheduleDropRequested(ServerPlayer sender, StationTileEntity te) {
        GlobalStation station = te.getStation();
        if (station == null) {
            return;
        }
        Train train = station.getPresentTrain();
        if (train == null) {
            return;
        }
        ItemStack schedule = train.runtime.returnSchedule();
        this.dropSchedule(sender, te, schedule);
    }

    private boolean disassembleAndEnterMode(ServerPlayer sender, StationTileEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            ItemStack schedule;
            Train train = station.getPresentTrain();
            BlockPos trackPosition = te.edgePoint.getGlobalPosition();
            ItemStack itemStack = schedule = train == null ? ItemStack.f_41583_ : train.runtime.returnSchedule();
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.m_7494_())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(ServerPlayer sender, StationTileEntity te, ItemStack schedule) {
        if (schedule.m_41619_()) {
            return;
        }
        if (sender.m_21205_().m_41619_()) {
            sender.m_150109_().m_150079_(schedule);
            return;
        }
        Vec3 v = VecHelper.getCenterOf((Vec3i)te.m_58899_());
        ItemEntity itemEntity = new ItemEntity(te.m_58904_(), v.f_82479_, v.f_82480_, v.f_82481_, schedule);
        itemEntity.m_20256_(Vec3.f_82478_);
        te.m_58904_().m_7967_((Entity)itemEntity);
    }

    @Override
    protected void applySettings(StationTileEntity te) {
    }
}

