/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class SuperByteBufferCache {
    protected final Map<Compartment<?>, Cache<Object, SuperByteBuffer>> caches = new HashMap();

    public synchronized void registerCompartment(Compartment<?> compartment) {
        this.caches.put(compartment, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().build());
    }

    public synchronized void registerCompartment(Compartment<?> compartment, long ticksUntilExpired) {
        this.caches.put(compartment, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().expireAfterAccess(ticksUntilExpired * 50L, TimeUnit.MILLISECONDS).build());
    }

    public <T> SuperByteBuffer get(Compartment<T> compartment, T key, Callable<SuperByteBuffer> callable) {
        Cache<Object, SuperByteBuffer> cache = this.caches.get(compartment);
        if (cache != null) {
            try {
                return (SuperByteBuffer)cache.get(key, callable);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public <T> void invalidate(Compartment<T> compartment, T key) {
        this.caches.get(compartment).invalidate(key);
    }

    public <T> void invalidate(Compartment<?> compartment) {
        this.caches.get(compartment).invalidateAll();
    }

    public void invalidate() {
        this.caches.forEach((compartment, cache) -> cache.invalidateAll());
    }

    public static class Compartment<T> {
    }
}

