/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class ClientEventHandler {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @SubscribeEvent
    public void onKeyInput(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (KeyRegistry.openCurios.m_90859_() && mc.m_91302_()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketOpenCurios(ItemStack.f_41583_));
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        Player player = evt.getEntity();
        if (!stack.m_41619_()) {
            Map<String, ISlotType> map;
            Set<String> curioTags;
            ArrayList<String> slots;
            List tooltip = evt.getToolTip();
            CompoundTag tag = stack.m_41783_();
            int i = 0;
            if (tag != null && tag.m_128425_("HideFlags", 99)) {
                i = tag.m_128451_("HideFlags");
            }
            if (!(slots = new ArrayList<String>(curioTags = (map = player != null ? CuriosApi.getItemStackSlots(stack, (LivingEntity)player) : CuriosApi.getItemStackSlots(stack)).keySet())).isEmpty()) {
                ArrayList<MutableComponent> tagTooltips = new ArrayList<MutableComponent>();
                MutableComponent slotsTooltip = Component.m_237115_((String)"curios.tooltip.slot").m_130946_(" ").m_130940_(ChatFormatting.GOLD);
                for (int j = 0; j < slots.size(); ++j) {
                    String key = "curios.identifier." + (String)slots.get(j);
                    MutableComponent type = Component.m_237115_((String)key);
                    if (j < slots.size() - 1) {
                        type = type.m_130946_(", ");
                    }
                    type = type.m_130940_(ChatFormatting.YELLOW);
                    slotsTooltip.m_7220_((Component)type);
                }
                tagTooltips.add(slotsTooltip);
                LazyOptional<ICurio> optionalCurio = CuriosApi.getCurio(stack);
                optionalCurio.ifPresent(curio -> {
                    List<Component> actualSlotsTooltip = curio.getSlotsTooltip(tagTooltips);
                    if (!actualSlotsTooltip.isEmpty()) {
                        tooltip.addAll(1, actualSlotsTooltip);
                    }
                });
                if (!optionalCurio.isPresent()) {
                    tooltip.addAll(1, tagTooltips);
                }
                ArrayList<MutableComponent> attributeTooltip = new ArrayList<MutableComponent>();
                for (String identifier : slots) {
                    Multimap<Attribute, AttributeModifier> multimap = CuriosApi.getAttributeModifiers(new SlotContext(identifier, (LivingEntity)player, 0, false, true), UUID.randomUUID(), stack);
                    if (multimap.isEmpty() || (i & 2) != 0) continue;
                    boolean init = false;
                    for (Map.Entry entry : multimap.entries()) {
                        if (entry.getKey() == null) continue;
                        if (!init) {
                            attributeTooltip.add(Component.m_237119_());
                            attributeTooltip.add(Component.m_237115_((String)("curios.modifiers." + identifier)).m_130940_(ChatFormatting.GOLD));
                            init = true;
                        }
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double amount = attributemodifier.m_22218_();
                        boolean flag = false;
                        if (player == null) continue;
                        if (attributemodifier.m_22209_() == ATTACK_DAMAGE_MODIFIER) {
                            AttributeInstance att = player.m_21051_(Attributes.f_22281_);
                            if (att != null) {
                                amount += att.m_22115_();
                            }
                            amount += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                            flag = true;
                        } else if (attributemodifier.m_22209_() == ATTACK_SPEED_MODIFIER) {
                            AttributeInstance att = player.m_21051_(Attributes.f_22283_);
                            if (att != null) {
                                amount += att.m_22115_();
                            }
                            flag = true;
                        }
                        double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? amount * 10.0 : amount) : amount * 100.0;
                        Object k = entry.getKey();
                        if (k instanceof SlotAttribute) {
                            SlotAttribute slotAttribute = (SlotAttribute)((Object)k);
                            if (amount > 0.0) {
                                attributeTooltip.add(Component.m_237110_((String)("curios.modifiers.slots.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)("curios.identifier." + slotAttribute.getIdentifier()))}).m_130940_(ChatFormatting.BLUE));
                                continue;
                            }
                            attributeTooltip.add(Component.m_237110_((String)("curios.modifiers.slots.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)("curios.identifier." + slotAttribute.getIdentifier()))}).m_130940_(ChatFormatting.RED));
                            continue;
                        }
                        if (flag) {
                            attributeTooltip.add(Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                            continue;
                        }
                        if (amount > 0.0) {
                            attributeTooltip.add(Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(amount < 0.0)) continue;
                        attributeTooltip.add(Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
                    }
                }
                optionalCurio.ifPresent(curio -> {
                    List<Component> actualAttributeTooltips = curio.getAttributesTooltip(attributeTooltip);
                    if (!actualAttributeTooltips.isEmpty()) {
                        tooltip.addAll(actualAttributeTooltips);
                    }
                });
                if (!optionalCurio.isPresent()) {
                    tooltip.addAll(attributeTooltip);
                }
            }
        }
    }
}

