/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.TimberFrameType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimberFrameBlock
extends AbstractBlock<TimberFrameBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/oak_planks"), ModTags.TIMBERFRAMES_FRAME, Blocks.f_50705_)).add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/dark_oak_planks"), ModTags.TIMBERFRAMES_CENTER, Blocks.f_50745_)).build();
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private final TimberFrameType timberFrameType;
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public TimberFrameBlock(TimberFrameType timberFrameType) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_278166_(PushReaction.PUSH_ONLY).m_60913_(3.0f, 1.0f).m_60999_().m_60955_());
        this.timberFrameType = timberFrameType;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public static String getName(TimberFrameType timberFrameType) {
        return timberFrameType.getName();
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId())) != null) {
            return block.getExplosionResistance(state, level, pos, explosion);
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId())) != null) {
            return block.m_5880_(block.m_49966_(), player, level, pos);
        }
        return super.m_5880_(state, player, level, pos);
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)this);
            this.fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public TimberFrameType getTimberFrameType() {
        return this.timberFrameType;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId())) != null) {
            return block.getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedRecipe(){

            public void m_7917_(@NotNull JsonObject json) {
                json.addProperty("count", (Number)(COMPONENTS.size() * 2));
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(TimberFrameBlock.this.getRegistryName(TimberFrameBlock.this.getBlock()));
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }});
    }
}

