/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.utils;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.client.model.IQuadTransformer;

public class ModelSpriteQuadTransformer
implements IQuadTransformer {
    private final TextureAtlasSprite target;

    public static IQuadTransformer create(TextureAtlasSprite target) {
        return new ModelSpriteQuadTransformer(target);
    }

    private ModelSpriteQuadTransformer(TextureAtlasSprite target) {
        this.target = target;
    }

    public void processInPlace(BakedQuad quad) {
        float minU = quad.m_173410_().m_118409_();
        float uDelta = quad.m_173410_().m_118410_() - minU;
        float minV = quad.m_173410_().m_118411_();
        float vDelta = quad.m_173410_().m_118412_() - minV;
        quad.f_111295_ = this.target;
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            float[] uv = new float[2];
            int offset = vertexIndex * STRIDE + UV0;
            uv[0] = Float.intBitsToFloat(quad.m_111303_()[offset]);
            uv[1] = Float.intBitsToFloat(quad.m_111303_()[offset + 1]);
            float u = (uv[0] - minU) / uDelta;
            float v = (uv[1] - minV) / vDelta;
            float newU = this.target.m_118367_((double)(u * 16.0f));
            float newV = this.target.m_118393_((double)(v * 16.0f));
            quad.m_111303_()[offset] = Float.floatToRawIntBits(newU);
            quad.m_111303_()[offset + 1] = Float.floatToRawIntBits(newV);
        }
    }
}

