/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FancyDoorBlockItem
extends DoubleHighBlockItem
implements IDoItem {
    private final FancyDoorBlock doorBlock;

    public FancyDoorBlockItem(FancyDoorBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.doorBlock = blockIn;
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.m_237110_((String)"domum_ornamentum.fancydoor.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        FancyDoorType doorType;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        try {
            doorType = stack.m_41784_().m_128441_("type") ? FancyDoorType.valueOf(stack.m_41784_().m_128461_("type").toUpperCase()) : FancyDoorType.FULL;
        }
        catch (Exception ex) {
            doorType = FancyDoorType.FULL;
        }
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.fancydoor.type.format", (Object[])new Object[]{Component.m_237115_((String)("domum_ornamentum.fancydoor.type.name." + doorType.getTranslationKeySuffix()))}));
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent trapDoorComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(0);
        Block trapDoorBlock = textureData.getTexturedComponents().getOrDefault(trapDoorComponent.getId(), trapDoorComponent.getDefault());
        Component trapDoorBlockName = BlockUtils.getHoverName(trapDoorBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.desc.frame", (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{trapDoorBlockName})}));
        IMateriallyTexturedBlockComponent trapDoorFrameComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(1);
        Block trapDoorFrameBlock = textureData.getTexturedComponents().getOrDefault(trapDoorFrameComponent.getId(), trapDoorFrameComponent.getDefault());
        Component trapDoorFrameBlockName = BlockUtils.getHoverName(trapDoorFrameBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.desc.center", (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{trapDoorFrameBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)new ResourceLocation("domum_ornamentum", "frame"), (Object)new ResourceLocation("domum_ornamentum", "center"));
    }

    @Override
    public ResourceLocation getGroup() {
        return new ResourceLocation("domum_ornamentum", "door");
    }
}

