/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.PaperWallBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperwallBlockItem
extends BlockItem
implements IDoItem {
    private final PaperWallBlock paperWallBlock;

    public PaperwallBlockItem(PaperWallBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.paperWallBlock = blockIn;
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.paperWallBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.m_237110_((String)"domum_ornamentum.paperwall.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.paperwall.header"));
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)this.paperWallBlock.getComponents().get(0);
        Block frameBlock = textureData.getTexturedComponents().getOrDefault(frameComponent.getId(), frameComponent.getDefault());
        Component frameBlockName = BlockUtils.getHoverName(frameBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.desc.frame", (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{frameBlockName})}));
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.paperWallBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.desc.center", (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{centerBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)new ResourceLocation("domum_ornamentum", "frame"), (Object)new ResourceLocation("domum_ornamentum", "center"));
    }

    @Override
    public ResourceLocation getGroup() {
        return new ResourceLocation("domum_ornamentum", "paperwall");
    }
}

