/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.effective_fg.particle_manager;

import bottomtextdanny.effective_fg.particle_manager.ParticleManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ParticleStitcher {
    private final ImmutableList<ParticleManager<?>> particleManagers;

    public ParticleStitcher(IEventBus bus, List<ParticleManager<?>> particleManagers) {
        this.particleManagers = ImmutableList.copyOf(particleManagers);
        bus.addListener(this::onTextureAtlasPre);
        bus.addListener(this::onTextureAtlasPost);
    }

    private void onTextureAtlasPre(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            this.particleManagers.forEach(manager -> manager.textures.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0)));
        }
    }

    private void onTextureAtlasPost(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            this.particleManagers.forEach(manager -> manager.spriteSet.rebind(manager.textures.stream().map(loc -> event.getAtlas().m_118316_(loc)).toList()));
        }
    }
}

