/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.items;

import com.teamremastered.endrem.EndRemastered;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.registers.ERItems;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndCrystalArmor
extends ArmorItem {
    public EndCrystalArmor(EquipmentSlot slot) {
        super((ArmorMaterial)new EndCrystalArmorMaterial(), slot, new Item.Properties().m_41491_(EndRemastered.TAB).m_41497_(Rarity.UNCOMMON));
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        int layer;
        int n = layer = slot == EquipmentSlot.LEGS ? 2 : 1;
        if ("overlay".equals(type)) {
            return "endrem:textures/models/armor/all_layer_" + layer + "_overlay.png";
        }
        return "endrem:textures/models/armor/end_crystal_layer_" + layer + ".png";
    }

    @ParametersAreNullableByDefault
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        assert (tooltip != null);
        tooltip.add((Component)new TranslatableComponent("item.endrem.armor.description.main"));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return Boolean.parseBoolean(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(4));
    }

    @MethodsReturnNonnullByDefault
    private static class EndCrystalArmorMaterial
    implements ArmorMaterial {
        private EndCrystalArmorMaterial() {
        }

        public int m_7366_(EquipmentSlot slotIn) {
            double factor = Double.parseDouble(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(0));
            return (int)((double)(new int[]{13, 15, 16, 11})[slotIn.m_20749_()] * factor);
        }

        public int m_7365_(EquipmentSlot slotIn) {
            double factor = Double.parseDouble(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(1));
            return (int)((double)(new int[]{3, 6, 8, 3})[slotIn.m_20749_()] * factor);
        }

        public int m_6646_() {
            return 15;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ERItems.END_CRYSTAL_INGOT.get()});
        }

        public float m_6651_() {
            return Float.parseFloat(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(2));
        }

        public float m_6649_() {
            return Float.parseFloat(ERConfig.END_CRYSTAL_ARMOR_STATS.getList().get(3));
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11675_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public String m_6082_() {
            return "end_crystal_fragment";
        }
    }
}

