/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.utils;

import com.teamremastered.endrem.utils.ERUtils;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiLocator {
    private final Supplier<ArrayList<String>> STRUCTURE_LIST_SUPPLIER;

    public MultiLocator(Supplier<ArrayList<String>> structureListSupplier) {
        this.STRUCTURE_LIST_SUPPLIER = structureListSupplier;
    }

    public ArrayList<String> getStructureList() {
        return this.STRUCTURE_LIST_SUPPLIER.get();
    }

    public BlockPos getNearestPosition(ServerLevel serverLevel, BlockPos playerPos) {
        int shortestStructureDistance = -1;
        BlockPos nearestStructurePos = null;
        for (String structureID : this.getStructureList()) {
            int structureDistance;
            ResourceLocation structureResourceLocation;
            String structureModId = structureID.split(":")[0];
            if (!ModList.get().isLoaded(structureModId) || !ForgeRegistries.STRUCTURE_FEATURES.containsKey(structureResourceLocation = new ResourceLocation(structureID))) continue;
            StructureFeature structureFeature = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(structureResourceLocation);
            assert (structureFeature != null);
            BlockPos structurePos = serverLevel.m_7726_().m_8481_().m_62161_(serverLevel, structureFeature, playerPos, 100, false);
            if (structurePos == null || shortestStructureDistance <= (structureDistance = ERUtils.getBlockDistance(structurePos, playerPos)) && shortestStructureDistance != -1) continue;
            shortestStructureDistance = structureDistance;
            nearestStructurePos = structurePos;
        }
        return nearestStructurePos;
    }
}

